/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.generation.custom.biomes;

import eu.scorpionltd.uhc.generation.custom.SugarGenerator;
import eu.scorpionltd.uhc.generation.custom.biomes.Biome;
import eu.scorpionltd.uhc.manager.settings.values.Values;
import eu.scorpionltd.utils.depends.Reflection;
import java.lang.reflect.Field;
import java.util.Map;
import net.minecraft.server.v1_8_R3.BiomeBase;
import net.minecraft.server.v1_8_R3.BiomeDecorator;
import net.minecraft.server.v1_8_R3.BiomeForest;
import net.minecraft.server.v1_8_R3.WorldGenBigTree;
import net.minecraft.server.v1_8_R3.WorldGenForest;
import net.minecraft.server.v1_8_R3.WorldGenTrees;

public class BiomesManager {
    public static void patchBiomes() throws ReflectiveOperationException {
        Field worldGenForestFirstField = BiomeForest.class.getDeclaredField("aD");
        worldGenForestFirstField.setAccessible(true);
        Field worldGenForestSecondField = BiomeForest.class.getDeclaredField("aE");
        worldGenForestSecondField.setAccessible(true);
        Field worldGenForestTreeField = BiomeForest.class.getDeclaredField("aF");
        worldGenForestTreeField.setAccessible(true);
        Reflection.setFinalStatic((Field)worldGenForestFirstField, (Object)new WorldGenForest(false, true));
        Reflection.setFinalStatic((Field)worldGenForestSecondField, (Object)new WorldGenForest(false, false));
        Field lo = BiomeBase.class.getDeclaredField("as");
        lo.setAccessible(true);
        Field mp = BiomeBase.class.getDeclaredField("aA");
        mp.setAccessible(true);
        Field mps = BiomeBase.class.getDeclaredField("aB");
        mps.setAccessible(true);
        Field mpsg = BiomeBase.class.getDeclaredField("aC");
        mpsg.setAccessible(true);
        BiomeBase[] biomes = BiomeBase.getBiomes();
        Map biomesMap = BiomeBase.o;
        Field biomeF = BiomeBase.class.getDeclaredField("biomes");
        biomeF.setAccessible(true);
        BiomeBase defaultBiome = BiomesManager.getDefaultBiome();
        if (!Values.DEFAULT_NONE.getBoolean()) {
            Reflection.setFinalStatic((Field)BiomeBase.class.getDeclaredField("ad"), (Object)defaultBiome);
        }
        BiomesManager.disableBiomes(biomes);
        for (int i = 0; i < biomes.length; ++i) {
            if (biomes[i] == null) continue;
            if (!biomesMap.containsKey(biomes[i].ah)) {
                biomes[i] = defaultBiome;
            }
            mp.set(biomes[i], new WorldGenTrees(true));
            mps.set(biomes[i], new WorldGenBigTree(true));
            BiomesManager.setReedsPerChunk(biomes[i], Values.POPULATOR_SUGAR_CANES.getInteger());
        }
        Reflection.setFinalStatic((Field)BiomeBase.class.getDeclaredField("biomes"), (Object)biomes);
    }

    private static BiomeBase getDefaultBiome() {
        if (Values.DEFAULT_BIRCH_FOREST.getBoolean()) {
            return BiomeBase.BIRCH_FOREST;
        }
        if (Values.DEFAULT_DARK_FOREST.getBoolean()) {
            return BiomeBase.ROOFED_FOREST;
        }
        if (Values.DEFAULT_DESERT.getBoolean()) {
            return BiomeBase.DESERT;
        }
        if (Values.DEFAULT_FOREST.getBoolean() || Values.DEFAULT_NONE.getBoolean()) {
            return BiomeBase.FOREST;
        }
        if (Values.DEFAULT_JUNGLE.getBoolean()) {
            return BiomeBase.JUNGLE;
        }
        if (Values.DEFAULT_MEGA_TAIGA.getBoolean()) {
            return BiomeBase.MEGA_TAIGA;
        }
        if (Values.DEFAULT_MESA.getBoolean()) {
            return BiomeBase.MESA;
        }
        if (Values.DEFAULT_MOUNTAINS.getBoolean()) {
            return BiomeBase.EXTREME_HILLS;
        }
        if (Values.DEFAULT_MUSHROOM.getBoolean()) {
            return BiomeBase.MUSHROOM_ISLAND;
        }
        if (Values.DEFAULT_PLAINS.getBoolean()) {
            return BiomeBase.PLAINS;
        }
        if (Values.DEFAULT_SAVANNA.getBoolean()) {
            return BiomeBase.SAVANNA;
        }
        if (Values.DEFAULT_SWAMPLAND.getBoolean()) {
            return BiomeBase.SWAMPLAND;
        }
        if (Values.DEFAULT_TAIGA.getBoolean()) {
            return BiomeBase.TAIGA;
        }
        return BiomeBase.PLAINS;
    }

    public static int getIdDefaultBiome() {
        int id = BiomesManager.getDefaultBiome().id;
        System.out.println("(SupUHC) ID Default Biome: " + id);
        return id;
    }

    private static void disableBiomes(BiomeBase[] biomesMap) {
        if (!Values.ENABLE_FOREST.getBoolean()) {
            BiomesManager.swap(biomesMap, Biome.FOREST);
            BiomesManager.swap(biomesMap, Biome.FOREST_HILLS);
            BiomesManager.swap(biomesMap, Biome.FLOWER_FOREST);
        }
        if (!Values.ENABLE_OCEANS.getBoolean()) {
            BiomesManager.swap(biomesMap, Biome.OCEAN);
            BiomesManager.swap(biomesMap, Biome.DEEP_OCEAN);
            BiomesManager.swap(biomesMap, Biome.FROZEN_OCEAN);
            BiomesManager.swap(biomesMap, Biome.FOREST_HILLS);
        }
        if (!Values.ENABLE_MESA.getBoolean()) {
            BiomesManager.swap(biomesMap, Biome.MESA_PLATEAU_M);
            BiomesManager.swap(biomesMap, Biome.MESA);
            BiomesManager.swap(biomesMap, Biome.MESA_PLATEAU);
            BiomesManager.swap(biomesMap, Biome.MESA_PLATEAU_F_M);
            BiomesManager.swap(biomesMap, Biome.MESA_PLATEAU_F);
            BiomesManager.swap(biomesMap, Biome.MESA_BRYCE);
        }
        if (!Values.ENABLE_DESERT.getBoolean()) {
            BiomesManager.swap(biomesMap, Biome.DESERT);
            BiomesManager.swap(biomesMap, Biome.DESERT_M);
            BiomesManager.swap(biomesMap, Biome.DESERT_HILLS);
        }
        if (!Values.ENABLE_SWAMPLAND.getBoolean()) {
            BiomesManager.swap(biomesMap, Biome.SWAMPLAND_M);
            BiomesManager.swap(biomesMap, Biome.SWAMPLAND);
            BiomesManager.swap(biomesMap, Biome.SWAMPLAND);
        }
        if (!Values.ENABLE_BEACH.getBoolean()) {
            BiomesManager.swap(biomesMap, Biome.BEACH);
            BiomesManager.swap(biomesMap, Biome.COLD_BEACH);
            BiomesManager.swap(biomesMap, Biome.STONE_BEACH);
        }
        if (!Values.ENABLE_TAIGA.getBoolean()) {
            BiomesManager.swap(biomesMap, Biome.TAIGA_M);
            BiomesManager.swap(biomesMap, Biome.TAIGA);
            BiomesManager.swap(biomesMap, Biome.TAIGA_HILLS);
            BiomesManager.swap(biomesMap, Biome.COLD_TAIGA);
            BiomesManager.swap(biomesMap, Biome.COLD_TAIGA_HILLS);
            BiomesManager.swap(biomesMap, Biome.COLD_TAIGA_M);
        }
        if (!Values.ENABLE_MEGA_TAIGA.getBoolean()) {
            BiomesManager.swap(biomesMap, Biome.MEGA_TAIGA);
            BiomesManager.swap(biomesMap, Biome.MEGA_TAIGA_HILLS);
        }
        if (!Values.ENABLE_JUNGLE.getBoolean()) {
            BiomesManager.swap(biomesMap, Biome.JUNGLE);
            BiomesManager.swap(biomesMap, Biome.JUNGLE_HILLS);
            BiomesManager.swap(biomesMap, Biome.JUNGLE_M);
            BiomesManager.swap(biomesMap, Biome.JUNGLE_EDGE_M);
            BiomesManager.swap(biomesMap, Biome.JUNGLE_HILLS);
        }
        if (!Values.ENABLE_SIMPLE_MOUNTAINS.getBoolean()) {
            BiomesManager.swap(biomesMap, Biome.ICE_MOUNTAINS);
            BiomesManager.swap(biomesMap, Biome.SMALL_MOUNTAINS);
            BiomesManager.swap(biomesMap, Biome.EXTREME_HILLS);
            BiomesManager.swap(biomesMap, Biome.EXTREME_HILLS_M);
            BiomesManager.swap(biomesMap, Biome.EXTREME_HILLS_PLUS_M);
            BiomesManager.swap(biomesMap, Biome.EXTREME_HILLS_PLUS);
        }
        if (!Values.ENABLE_BIRCH_FOREST.getBoolean()) {
            BiomesManager.swap(biomesMap, Biome.BIRCH_FOREST_M);
            BiomesManager.swap(biomesMap, Biome.BIRCH_FOREST_HILLS_M);
            BiomesManager.swap(biomesMap, Biome.BIRCH_FOREST);
            BiomesManager.swap(biomesMap, Biome.BIRCH_FOREST_HILLS);
        }
        if (!Values.ENABLE_DARK_FOREST.getBoolean()) {
            BiomesManager.swap(biomesMap, Biome.ROOFED_FOREST_M);
            BiomesManager.swap(biomesMap, Biome.ROOFED_FOREST);
        }
        if (!Values.ENABLE_SAVANNA.getBoolean()) {
            BiomesManager.swap(biomesMap, Biome.SAVANNA_M);
            BiomesManager.swap(biomesMap, Biome.SAVANNA);
            BiomesManager.swap(biomesMap, Biome.SAVANNA_PLATEAU_M);
            BiomesManager.swap(biomesMap, Biome.SAVANNA_PLATEAU);
        }
        if (!Values.ENABLE_RIVER.getBoolean()) {
            BiomesManager.swap(biomesMap, Biome.RIVER);
            BiomesManager.swap(biomesMap, Biome.FROZEN_RIVER);
        }
        if (!Values.ENABLE_PLAINS.getBoolean()) {
            BiomesManager.swap(biomesMap, Biome.PLAINS);
            BiomesManager.swap(biomesMap, Biome.ICE_PLAINS);
            BiomesManager.swap(biomesMap, Biome.SUN_FLOWER_PLAINS);
            BiomesManager.swap(biomesMap, Biome.ICE_PLAINS_SPIKES);
        }
        if (!Values.ENABLE_MUSHROOM.getBoolean()) {
            BiomesManager.swap(biomesMap, Biome.MUSHROOM_ISLAND);
            BiomesManager.swap(biomesMap, Biome.MUSHROOM_SHORE);
        }
        if (!Values.ENABLE_OTHERS_MOUNTAINS.getBoolean()) {
            BiomesManager.swap(biomesMap, Biome.BIRCH_FOREST_HILLS_M);
            BiomesManager.swap(biomesMap, Biome.BIRCH_FOREST_HILLS);
            BiomesManager.swap(biomesMap, Biome.COLD_TAIGA_HILLS);
            BiomesManager.swap(biomesMap, Biome.DESERT_HILLS);
            BiomesManager.swap(biomesMap, Biome.FOREST_HILLS);
            BiomesManager.swap(biomesMap, Biome.JUNGLE_HILLS);
            BiomesManager.swap(biomesMap, Biome.MEGA_TAIGA_HILLS);
            BiomesManager.swap(biomesMap, Biome.TAIGA_HILLS);
        }
        if (!Values.ENABLE_COLD_BIOMES.getBoolean()) {
            BiomesManager.swap(biomesMap, Biome.ICE_PLAINS);
            BiomesManager.swap(biomesMap, Biome.FROZEN_RIVER);
            BiomesManager.swap(biomesMap, Biome.COLD_BEACH);
            BiomesManager.swap(biomesMap, Biome.COLD_TAIGA);
            BiomesManager.swap(biomesMap, Biome.COLD_TAIGA_M);
            BiomesManager.swap(biomesMap, Biome.COLD_TAIGA_HILLS);
            BiomesManager.swap(biomesMap, Biome.FROZEN_OCEAN);
        }
    }

    public static void swap(BiomeBase[] biomes, Biome from) {
        biomes[from.getId().intValue()] = BiomesManager.getDefaultBiome();
    }

    private static void setReedsPerChunk(BiomeBase biome, int value) throws NoSuchFieldException, IllegalAccessException {
        if (biome == BiomeBase.HELL || biome == BiomeBase.SKY) {
            return;
        }
        Reflection.setValue((Object)biome.as, BiomeDecorator.class, (boolean)true, (String)"w", (Object)((Object)new SugarGenerator(value)));
    }
}

