/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.generation.custom.biomes;

import eu.scorpionltd.listeners.EventManager;
import eu.scorpionltd.uhc.UHC;
import eu.scorpionltd.uhc.events.custom.world.ChunkPregenEvent;
import eu.scorpionltd.uhc.manager.settings.values.Values;
import eu.scorpionltd.uhc.manager.world.GameWorldManager;
import eu.scorpionltd.uhc.util.world.WorldUtil;
import eu.scorpionltd.utils.depends.Reflection;
import java.lang.reflect.Field;
import java.util.Random;
import net.minecraft.server.v1_8_R3.BiomeBase;
import net.minecraft.server.v1_8_R3.BiomeForest;
import net.minecraft.server.v1_8_R3.Block;
import net.minecraft.server.v1_8_R3.BlockPosition;
import net.minecraft.server.v1_8_R3.ChunkProviderGenerate;
import net.minecraft.server.v1_8_R3.IChunkProvider;
import net.minecraft.server.v1_8_R3.World;
import net.minecraft.server.v1_8_R3.WorldGenBigTree;
import net.minecraft.server.v1_8_R3.WorldGenForest;
import net.minecraft.server.v1_8_R3.WorldGenForestTree;
import net.minecraft.server.v1_8_R3.WorldGenLakes;
import net.minecraft.server.v1_8_R3.WorldGenSwampTree;
import net.minecraft.server.v1_8_R3.WorldGenTrees;
import org.bukkit.Chunk;
import org.bukkit.Material;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class BetterCenter
implements Listener {
    public BetterCenter() throws ReflectiveOperationException {
        if (Values.POLULATOR_WATER_MIDDLE.getBoolean()) {
            EventManager.registerEvent((Listener)this, (Plugin)UHC.getInstance());
        }
        if (Values.POLULATOR_TREE_MIDDLE.getBoolean()) {
            this.load();
        }
    }

    public void load() throws ReflectiveOperationException {
        Field worldGenTreesField = BiomeBase.class.getDeclaredField("aA");
        worldGenTreesField.setAccessible(true);
        Field worldGenBigTreeField = BiomeBase.class.getDeclaredField("aB");
        worldGenBigTreeField.setAccessible(true);
        Field worldGenSwampTreeField = BiomeBase.class.getDeclaredField("aC");
        worldGenSwampTreeField.setAccessible(true);
        for (BiomeBase biome : BiomeBase.getBiomes()) {
            if (biome == null) continue;
            worldGenTreesField.set(biome, (Object)new WorldGenTreesPatched(false));
            worldGenBigTreeField.set(biome, (Object)new WorldGenBigTreePatched(false));
            worldGenSwampTreeField.set(biome, (Object)new WorldGenSwampTreePatched());
        }
        Field worldGenForestFirstField = BiomeForest.class.getDeclaredField("aD");
        worldGenForestFirstField.setAccessible(true);
        Field worldGenForestSecondField = BiomeForest.class.getDeclaredField("aE");
        worldGenForestSecondField.setAccessible(true);
        Field worldGenForestTreeField = BiomeForest.class.getDeclaredField("aF");
        worldGenForestTreeField.setAccessible(true);
        Reflection.setFinalStatic((Field)worldGenForestFirstField, (Object)((Object)new WorldGenForestPatched(false, true)));
        Reflection.setFinalStatic((Field)worldGenForestSecondField, (Object)((Object)new WorldGenForestPatched(false, false)));
        Reflection.setFinalStatic((Field)worldGenForestTreeField, (Object)((Object)new WorldGenForestTreePatched(false)));
    }

    @EventHandler
    public void pregenChunk(ChunkPregenEvent e) {
        if (e.getChunk() == null || !GameWorldManager.getGameWorld(e.getChunk().getWorld()).isGameWorld()) {
            return;
        }
        Chunk chunk = e.getChunk();
        if (chunk == null) {
            return;
        }
        int centerX = Values.BORDER_CENTER_X.getInteger();
        int centerZ = Values.BORDER_CENTER_Z.getInteger();
        int radius = 250;
        for (int x = chunk.getX(); x < chunk.getX() + 16; ++x) {
            for (int z = chunk.getZ(); z < chunk.getZ() + 16; ++z) {
                for (int y = 40; y < 100; ++y) {
                    org.bukkit.block.Block block = chunk.getBlock(x, y, z);
                    if (block.getX() <= -radius + centerX || block.getX() >= radius + centerX || block.getZ() <= -radius + centerZ || block.getZ() >= radius + centerZ) {
                        return;
                    }
                    if ((block.getType() == Material.STATIONARY_WATER || block.getType() == Material.ICE || block.getType() == Material.PACKED_ICE) && WorldUtil.isSurface(block.getLocation())) {
                        block.setType(Material.GRASS);
                    }
                    if (block.getType() != Material.WATER_LILY) continue;
                    block.setType(Material.AIR);
                }
            }
        }
    }

    private static class WorldGenTreesPatched
    extends WorldGenTrees {
        WorldGenTreesPatched(boolean b) {
            super(b);
        }

        public boolean generate(World world, Random random, BlockPosition blockPosition) {
            int centerX = Values.BORDER_CENTER_X.getInteger();
            int centerZ = Values.BORDER_CENTER_Z.getInteger();
            return (blockPosition.getX() <= -100 + centerX || blockPosition.getX() >= 100 + centerX || blockPosition.getZ() <= -100 + centerZ || blockPosition.getZ() >= 100 + centerZ) && super.generate(world, random, blockPosition);
        }
    }

    private static class WorldGenBigTreePatched
    extends WorldGenBigTree {
        WorldGenBigTreePatched(boolean b) {
            super(b);
        }

        public boolean generate(World world, Random random, BlockPosition blockPosition) {
            int centerX = Values.BORDER_CENTER_X.getInteger();
            int centerZ = Values.BORDER_CENTER_Z.getInteger();
            return (blockPosition.getX() <= -100 + centerX || blockPosition.getX() >= 100 + centerX || blockPosition.getZ() <= -100 + centerZ || blockPosition.getZ() >= 100 + centerZ) && super.generate(world, random, blockPosition);
        }
    }

    private static class WorldGenSwampTreePatched
    extends WorldGenSwampTree {
        private WorldGenSwampTreePatched() {
        }

        public boolean generate(World world, Random random, BlockPosition blockPosition) {
            int centerX = Values.BORDER_CENTER_X.getInteger();
            int centerZ = Values.BORDER_CENTER_Z.getInteger();
            return (blockPosition.getX() <= -100 + centerX || blockPosition.getX() >= 100 + centerX || blockPosition.getZ() <= -100 + centerZ || blockPosition.getZ() >= 100 + centerZ) && super.generate(world, random, blockPosition);
        }
    }

    private static class WorldGenForestPatched
    extends WorldGenForest {
        WorldGenForestPatched(boolean b, boolean b1) {
            super(b, b1);
        }

        public boolean generate(World world, Random random, BlockPosition blockPosition) {
            int centerX = Values.BORDER_CENTER_X.getInteger();
            int centerZ = Values.BORDER_CENTER_Z.getInteger();
            return (blockPosition.getX() <= -100 + centerX || blockPosition.getX() >= 100 + centerX || blockPosition.getZ() <= -100 + centerZ || blockPosition.getZ() >= 100 + centerZ) && super.generate(world, random, blockPosition);
        }
    }

    private static class WorldGenForestTreePatched
    extends WorldGenForestTree {
        WorldGenForestTreePatched(boolean flag) {
            super(flag);
        }

        public boolean generate(World world, Random random, BlockPosition blockPosition) {
            int centerX = Values.BORDER_CENTER_X.getInteger();
            int centerZ = Values.BORDER_CENTER_Z.getInteger();
            return (blockPosition.getX() <= -100 + centerX || blockPosition.getX() >= 100 + centerX || blockPosition.getZ() <= -100 + centerZ || blockPosition.getZ() >= 100 + centerZ) && super.generate(world, random, blockPosition);
        }
    }

    private static class WorldGenLakesPatched
    extends WorldGenLakes {
        public WorldGenLakesPatched(Block block) {
            super(block);
        }

        public boolean generate(World world, Random random, BlockPosition blockPosition) {
            int centerX = Values.BORDER_CENTER_X.getInteger();
            int centerZ = Values.BORDER_CENTER_Z.getInteger();
            return (blockPosition.getX() <= -100 + centerX || blockPosition.getX() >= 100 + centerX || blockPosition.getZ() <= -100 + centerZ || blockPosition.getZ() >= 100 + centerZ) && super.generate(world, random, blockPosition);
        }
    }

    private static class ChunkProviderGeneration
    extends ChunkProviderGenerate {
        public ChunkProviderGeneration(World world, long l, boolean b, String s) {
            super(world, l, b, s);
        }

        public void getChunkAt(IChunkProvider ichunkprovider, int i, int j) {
        }
    }
}

