/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.generation;

import eu.scorpionltd.uhc.UHC;
import eu.scorpionltd.uhc.events.custom.world.ChunkPregenEvent;
import eu.scorpionltd.uhc.generation.GenerationManager;
import eu.scorpionltd.uhc.manager.langues.msg.MEnum;
import eu.scorpionltd.uhc.manager.settings.values.ValueCategorie;
import eu.scorpionltd.uhc.manager.settings.values.Values;
import eu.scorpionltd.uhc.manager.world.GameWorld;
import eu.scorpionltd.uhc.util.server.ServerUtil;
import eu.scorpionltd.uhc.util.server.enums.Gamerule;
import eu.scorpionltd.uhc.util.world.WorldUtil;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class LoadingChunk {
    private final GameWorld gameWorld;
    private final World world;
    private final int size;
    private final int centerX;
    private final int centerZ;
    private final boolean isNerfed;
    private final boolean isPigReplaced;
    private final boolean isSheepReplaced;
    private BukkitTask task;
    private int nChunk;
    private int last;
    private long startTime;

    public LoadingChunk(GameWorld gameWorld, ValueCategorie cat, boolean isCustomWorld) {
        this.size = gameWorld.haveCustomPregenSize() ? gameWorld.getCustomPregenSize() : Values.BORDER_SIZE_INIT.getInteger() + 100;
        this.centerX = gameWorld.haveCustomPregenSize() ? 0 : Values.BORDER_CENTER_X.getInteger();
        this.centerZ = gameWorld.haveCustomPregenSize() ? 0 : Values.BORDER_CENTER_Z.getInteger();
        this.gameWorld = gameWorld;
        this.world = gameWorld.getWorld();
        this.isNerfed = Values.POPULATOR_NERF_PREGEN.getBoolean();
        this.isPigReplaced = Values.ENTITY_PIG_REPLACE.getBoolean();
        this.isSheepReplaced = Values.ENTITY_SHEEP_REPLACE.getBoolean();
        Gamerule.FIRE_EXPAND.set(this.world, false);
        this.world.setGameRuleValue("randomTickSpeed", "0");
        GenerationManager.getWorldsPregen().add(this.world);
    }

    public LoadingChunk(GameWorld gameWorld, ValueCategorie cat) {
        this(gameWorld, cat, false);
    }

    public void load() {
        this.startTime = System.currentTimeMillis();
        MEnum.START_PREGEN.sendAll(this.gameWorld.getColorName());
        this.world.getEntities().forEach(ent -> {
            if (ent != null && ent.getType() != EntityType.MINECART_CHEST) {
                ent.remove();
            }
        });
        this.task = Bukkit.getScheduler().runTaskTimer((Plugin)UHC.getInstance(), new Runnable(){
            private int todo;
            private int x;
            private int z;
            {
                this.todo = LoadingChunk.this.size * 2 * (LoadingChunk.this.size * 2) / 256;
                this.x = -(LoadingChunk.this.size + LoadingChunk.this.centerX);
                this.z = -(LoadingChunk.this.size + LoadingChunk.this.centerZ);
            }

            @Override
            public void run() {
                if (LoadingChunk.this.isNerfed && ServerUtil.getDoubleTPS() < 5.0) {
                    return;
                }
                for (int i = 0; i < 50; ++i) {
                    Chunk chunk = LoadingChunk.this.world.getChunkAt(LoadingChunk.this.world.getBlockAt(this.x, 64, this.z));
                    chunk.load(true);
                    if (WorldUtil.getEnv(LoadingChunk.this.world) == World.Environment.NORMAL) {
                        LoadingChunk.this.checkPigReplaced(chunk);
                        LoadingChunk.this.checkSheepReplaced(chunk);
                    }
                    chunk.load(false);
                    Bukkit.getPluginManager().callEvent((Event)new ChunkPregenEvent(chunk));
                    int percentage = LoadingChunk.this.nChunk * 100 / this.todo;
                    if (percentage > LoadingChunk.this.last) {
                        LoadingChunk.this.last = percentage;
                        MEnum.COOLDOWN_PREGEN.sendAll(LoadingChunk.this.gameWorld.getColorName(), percentage);
                    }
                    this.z += 16;
                    if (this.z >= LoadingChunk.this.size) {
                        this.z = -LoadingChunk.this.size;
                        this.x += 16;
                    }
                    if (this.x >= LoadingChunk.this.size) {
                        LoadingChunk.this.task.cancel();
                        int calculedTime = Math.round((System.currentTimeMillis() - LoadingChunk.this.startTime) / 1000L);
                        MEnum.FINISH_PREGEN.sendAll(LoadingChunk.this.gameWorld.getColorName(), calculedTime);
                        LoadingChunk.this.world.setGameRuleValue("randomTickSpeed", "3");
                        GenerationManager.pregenNextWorld();
                        return;
                    }
                    LoadingChunk.this.nChunk++;
                }
            }
        }, 0L, 0L);
    }

    private void checkPigReplaced(Chunk chunk) {
        if (!this.isPigReplaced) {
            return;
        }
        for (Entity entity : chunk.getEntities()) {
            if (entity == null || entity.getType() == null || entity.getType() != EntityType.PIG) continue;
            Location loc = entity.getLocation();
            entity.remove();
            loc.getWorld().spawnEntity(loc, EntityType.COW);
        }
    }

    private void checkSheepReplaced(Chunk chunk) {
        if (!this.isSheepReplaced) {
            return;
        }
        for (Entity entity : chunk.getEntities()) {
            if (entity == null || entity.getType() == null || entity.getType() != EntityType.SHEEP) continue;
            Location loc = entity.getLocation();
            entity.remove();
            loc.getWorld().spawnEntity(loc, EntityType.COW);
        }
    }
}

