/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.generation;

import eu.scorpionltd.listeners.EventManager;
import eu.scorpionltd.uhc.UHC;
import eu.scorpionltd.uhc.events.custom.world.PregenFinishEvent;
import eu.scorpionltd.uhc.generation.custom.WorldGenCavesPatched;
import eu.scorpionltd.uhc.generation.custom.biomes.BetterCenter;
import eu.scorpionltd.uhc.generation.custom.biomes.BiomesManager;
import eu.scorpionltd.uhc.generation.custom.ores.OrePopulator;
import eu.scorpionltd.uhc.generation.event.XrayEvent;
import eu.scorpionltd.uhc.manager.langues.msg.MEnum;
import eu.scorpionltd.uhc.manager.settings.values.Values;
import eu.scorpionltd.uhc.manager.world.GameWorld;
import eu.scorpionltd.uhc.manager.world.GameWorldManager;
import eu.scorpionltd.uhc.util.server.enums.Pregen;
import eu.scorpionltd.uhc.util.world.TeleportationUtil;
import eu.scorpionltd.utils.player.ScorpionPlayer;
import eu.scorpionltd.utils.task.Cooldown;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.WorldType;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.generator.BlockPopulator;
import org.bukkit.plugin.Plugin;

public class GenerationManager {
    private static Listener xrayEvent = null;
    private static List<World> worldsPregen = new ArrayList<World>();

    public static void launchOnlyGeneration(ScorpionPlayer sp) {
        if (Pregen.getCurrentPregen() == Pregen.PROGRESS) {
            MEnum.PROGRESS_PREGEN.sendTo(sp, new Object[0]);
            return;
        }
        MEnum.GENERATION_FREEZE.sendAll(new Object[0]);
        TeleportationUtil.teleportAllToLobby();
        new Cooldown(1){

            public void onFinish() {
                GenerationManager.removeWorlds();
                MEnum.GENERATION_FINISH.sendAll(new Object[0]);
            }
        };
    }

    public static void launchOnlyPregeneration(ScorpionPlayer sp) {
        if (Pregen.getCurrentPregen() == Pregen.PROGRESS) {
            MEnum.PROGRESS_PREGEN.sendTo(sp, new Object[0]);
            return;
        }
        Pregen.setCurrentPregen(Pregen.PROGRESS);
        TeleportationUtil.teleportAllToLobby();
        worldsPregen = new ArrayList<World>();
        new Cooldown(1){

            public void onFinish() {
                GenerationManager.pregenNextWorld();
            }
        };
    }

    public static void launchCompleteGeneration(ScorpionPlayer sp) {
        if (Pregen.getCurrentPregen() == Pregen.PROGRESS) {
            MEnum.PROGRESS_PREGEN.sendTo(sp, new Object[0]);
            return;
        }
        Pregen.setCurrentPregen(Pregen.PROGRESS);
        MEnum.GENERATION_FREEZE.sendAll(new Object[0]);
        TeleportationUtil.teleportAllToLobby();
        worldsPregen = new ArrayList<World>();
        new Cooldown(1){

            public void onFinish() {
                boolean haveRemovedWorlds = GenerationManager.removeWorlds();
                if (haveRemovedWorlds) {
                    GenerationManager.pregenNextWorld();
                }
            }
        };
    }

    protected static boolean removeWorlds() {
        try {
            BiomesManager.patchBiomes();
            if (Values.POLULATOR_TREE_MIDDLE.getBoolean() || Values.POLULATOR_WATER_MIDDLE.getBoolean()) {
                new BetterCenter();
            }
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
        }
        for (GameWorld gameWorld : GameWorldManager.getGameWorlds()) {
            if (!gameWorld.canBeGenerate()) continue;
            gameWorld.removeWorld();
            gameWorld.setWorld(null);
            System.gc();
            int worldValue = Values.POPULATOR_WORLD_TYPE.getInteger();
            WorldType worldType = WorldType.NORMAL;
            if (gameWorld.getGameEnvironment().getEnvironment() == World.Environment.NORMAL) {
                worldType = worldValue == 0 ? WorldType.NORMAL : (worldValue == 1 ? WorldType.LARGE_BIOMES : (worldValue == 2 ? WorldType.FLAT : WorldType.AMPLIFIED));
            }
            String generatorSettings = "";
            if (gameWorld.haveCustomGeneratorSettings()) {
                generatorSettings = gameWorld.getCustomGeneratorSettings();
            } else if (worldValue == 2) {
                generatorSettings = "3;minecraft:bedrock,2*minecraft:dirt,minecraft:grass;1;village(distance=0 size=150)";
            } else {
                boolean useMonuments = Values.POPULATOR_OCEAN_MONUMENTS.getBoolean();
                int dungeonChance = Values.POPULATOR_AMPLIFIED_DUNGEONS.getBoolean() ? 750 : 8;
                generatorSettings = "{\"useMonuments\":" + useMonuments + ",\"dungeonChance\":" + dungeonChance + "}";
            }
            World newWorld = gameWorld.generateWorld(worldType, generatorSettings);
            OrePopulator orePopulator = new OrePopulator();
            orePopulator.addRule(new OrePopulator.Rule(Material.COAL_ORE, Values.POPULATOR_COAL_ORE.getInteger(), 0, 128, 17));
            orePopulator.addRule(new OrePopulator.Rule(Material.IRON_ORE, Values.POPULATOR_IRON_ORE.getInteger(), 0, 64, 9));
            orePopulator.addRule(new OrePopulator.Rule(Material.GOLD_ORE, Values.POPULATOR_GOLD_ORE.getInteger(), 0, 32, 9));
            orePopulator.addRule(new OrePopulator.Rule(Material.REDSTONE_ORE, Values.POPULATOR_REDSTONE_ORE.getInteger(), 0, 16, 8));
            orePopulator.addRule(new OrePopulator.Rule(Material.DIAMOND_ORE, Values.POPULATOR_DIAMOND_ORE.getInteger(), 0, 16, 8));
            orePopulator.addRule(new OrePopulator.Rule(Material.LAPIS_ORE, Values.POPULATOR_LAPIS_ORE.getInteger(), 0, 32, 7));
            newWorld.getPopulators().add(orePopulator);
            for (BlockPopulator populators : gameWorld.getPopulators()) {
                newWorld.getPopulators().add(populators);
            }
            if (gameWorld.getGameEnvironment().getEnvironment() != World.Environment.NORMAL || worldValue == 2) continue;
            try {
                WorldGenCavesPatched.load(newWorld, Values.POPULATOR_CAVES.getInteger());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            System.out.println("GENERATION: FINISH GENERATE WORLD " + gameWorld.getName());
        }
        return true;
    }

    public static void pregenNextWorld() {
        System.out.println("PREGENERATION: SEARCH NEXT WORLD");
        if (Values.POPULATOR_ANTI_XRAY.getBoolean() && xrayEvent == null) {
            xrayEvent = new XrayEvent();
            EventManager.registerEvent((Listener)xrayEvent, (Plugin)UHC.getInstance());
        }
        for (GameWorld gameWorld : GameWorldManager.getGameWorlds()) {
            if (!gameWorld.canBePregenerate() || worldsPregen.contains(gameWorld.getWorld())) continue;
            System.out.println("PREGENERATION: START PREGEN NEXT WORLD " + gameWorld.getName());
            gameWorld.pregenerateWorld();
            return;
        }
        System.out.println("PREGENERATION: FINISH ALL WORLDS");
        MEnum.GENERATION_FINISH.sendAll(new Object[0]);
        Pregen.setCurrentPregen(Pregen.DONE);
        Bukkit.getPluginManager().callEvent((Event)new PregenFinishEvent());
    }

    public static List<World> getWorldsPregen() {
        return worldsPregen;
    }
}

