/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.events.world;

import eu.scorpionltd.uhc.manager.langues.msg.MEnum;
import eu.scorpionltd.uhc.manager.settings.values.Values;
import eu.scorpionltd.uhc.manager.world.GameEnvironment;
import eu.scorpionltd.uhc.manager.world.GameWorld;
import eu.scorpionltd.uhc.manager.world.GameWorldManager;
import eu.scorpionltd.uhc.util.world.monde.ArenaUtil;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.TravelAgent;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPortalEvent;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.world.PortalCreateEvent;

public class PortalEvent
implements Listener {
    @EventHandler(ignoreCancelled=true, priority=EventPriority.NORMAL)
    public void onPortalAccess(PlayerPortalEvent e) {
        Player player = e.getPlayer();
        if (e.getCause() == PlayerTeleportEvent.TeleportCause.NETHER_PORTAL) {
            Location location;
            if (!Values.NETHER_ACCESS.getBoolean()) {
                e.setCancelled(true);
                MEnum.EVENTS_NETHER_ACCESS.sendTo(player, new Object[0]);
                return;
            }
            e.useTravelAgent(true);
            TravelAgent agent = e.getPortalTravelAgent();
            agent.setCanCreatePortal(true);
            e.setPortalTravelAgent(agent);
            GameWorld gameWorld = GameWorldManager.getGameWorld(player.getWorld());
            if (gameWorld.getGameEnvironment() == GameEnvironment.OVERWORLD) {
                if (gameWorld.getNether() == null) {
                    e.setCancelled(true);
                    MEnum.EVENTS_NETHER_ACCESS.sendTo(player, new Object[0]);
                    return;
                }
                location = new Location(gameWorld.getNether().getWorld(), (double)(e.getFrom().getBlockX() / 8), (double)e.getFrom().getBlockY(), (double)(e.getFrom().getBlockZ() / 8));
            } else {
                double d;
                GameWorld overworld = GameWorldManager.getLinkedWorld(gameWorld);
                if (overworld == null) {
                    e.setCancelled(true);
                    MEnum.EVENTS_NETHER_ACCESS.sendTo(player, new Object[0]);
                    return;
                }
                double size = overworld.getWorld().getWorldBorder().getSize() / 2.0 - 10.0;
                double x = e.getFrom().getBlockX() * 8;
                if (x >= size) {
                    x = size;
                }
                if (x <= -size) {
                    x = -size;
                }
                double z = e.getFrom().getBlockZ() * 8;
                if (d >= size) {
                    z = size;
                }
                if (z <= -size) {
                    z = -size;
                }
                location = new Location(overworld.getWorld(), x, (double)e.getFrom().toVector().getBlockY(), z);
            }
            e.setTo(agent.findOrCreate(location));
            return;
        }
        if (e.getCause() == PlayerTeleportEvent.TeleportCause.END_PORTAL) {
            if (!Values.END_ACCESS.getBoolean()) {
                e.setCancelled(true);
                MEnum.EVENTS_END_ACCESS.sendTo(player, new Object[0]);
                return;
            }
            GameWorld gameWorld = GameWorldManager.getGameWorld(player.getWorld());
            if (gameWorld.getGameEnvironment() == GameEnvironment.OVERWORLD) {
                if (gameWorld.getEnd() == null) {
                    e.setCancelled(true);
                    MEnum.EVENTS_END_ACCESS.sendTo(player, new Object[0]);
                    return;
                }
                Location loc = new Location(ArenaUtil.getArenaEnd(), 100.0, 50.0, 0.0);
                e.setTo(loc);
                this.createEndPlatform(loc);
            } else {
                GameWorld overworld = GameWorldManager.getLinkedWorld(gameWorld);
                if (overworld == null) {
                    e.setCancelled(true);
                    MEnum.EVENTS_END_ACCESS.sendTo(player, new Object[0]);
                    return;
                }
                e.setTo(overworld.getWorld().getSpawnLocation());
            }
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.NORMAL)
    public void onEntityPortalAccess(EntityPortalEvent e) {
        if (e.getEntity() == null || e.getFrom() == null || e.getTo() == null) {
            return;
        }
        if (e.getFrom().getWorld().getEnvironment() == World.Environment.NETHER || e.getTo().getWorld().getEnvironment() == World.Environment.NETHER) {
            Location location;
            if (!Values.NETHER_ACCESS.getBoolean()) {
                e.setCancelled(true);
                return;
            }
            e.useTravelAgent(true);
            TravelAgent agent = e.getPortalTravelAgent();
            agent.setCanCreatePortal(true);
            e.setPortalTravelAgent(agent);
            GameWorld gameWorld = GameWorldManager.getGameWorld(e.getFrom().getWorld());
            if (gameWorld.getGameEnvironment() == GameEnvironment.OVERWORLD) {
                if (gameWorld.getNether() == null) {
                    e.setCancelled(true);
                    return;
                }
                location = new Location(gameWorld.getNether().getWorld(), (double)(e.getFrom().getBlockX() / 8), (double)e.getFrom().getBlockY(), (double)(e.getFrom().getBlockZ() / 8));
            } else {
                double d;
                GameWorld overworld = GameWorldManager.getLinkedWorld(gameWorld);
                if (overworld == null) {
                    e.setCancelled(true);
                    return;
                }
                double size = overworld.getWorld().getWorldBorder().getSize() / 2.0 - 10.0;
                double x = e.getFrom().getBlockX() * 8;
                if (x >= size) {
                    x = size;
                }
                if (x <= -size) {
                    x = -size;
                }
                double z = e.getFrom().getBlockZ() * 8;
                if (d >= size) {
                    z = size;
                }
                if (z <= -size) {
                    z = -size;
                }
                location = new Location(overworld.getWorld(), x, (double)e.getFrom().toVector().getBlockY(), z);
            }
            e.setTo(agent.findOrCreate(location));
            return;
        }
        if (e.getFrom().getWorld().getEnvironment() == World.Environment.THE_END || e.getTo().getWorld().getEnvironment() == World.Environment.THE_END) {
            if (!Values.END_ACCESS.getBoolean()) {
                e.setCancelled(true);
                return;
            }
            GameWorld gameWorld = GameWorldManager.getGameWorld(e.getFrom().getWorld());
            if (gameWorld.getGameEnvironment() == GameEnvironment.OVERWORLD) {
                if (gameWorld.getEnd() == null) {
                    e.setCancelled(true);
                    return;
                }
                Location loc = new Location(ArenaUtil.getArenaEnd(), 100.0, 50.0, 0.0);
                e.setTo(loc);
                this.createEndPlatform(loc);
            } else {
                GameWorld overworld = GameWorldManager.getLinkedWorld(gameWorld);
                if (overworld == null) {
                    e.setCancelled(true);
                    return;
                }
                e.setTo(overworld.getWorld().getSpawnLocation());
            }
            return;
        }
    }

    private void createEndPlatform(Location loc) {
        Block block = loc.getBlock();
        for (int x = block.getX() - 2; x <= block.getX() + 2; ++x) {
            for (int z = block.getZ() - 2; z <= block.getZ() + 2; ++z) {
                Block platformBlock = loc.getWorld().getBlockAt(x, block.getY() - 1, z);
                if (platformBlock.getType() != Material.OBSIDIAN) {
                    platformBlock.setType(Material.OBSIDIAN);
                }
                for (int yMod = 1; yMod <= 3; ++yMod) {
                    Block b = platformBlock.getRelative(BlockFace.UP, yMod);
                    if (b.getType() == Material.AIR) continue;
                    b.setType(Material.AIR);
                }
            }
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.NORMAL)
    public void onPortalCreate(PortalCreateEvent e) {
        e.getBlocks().forEach(b -> {
            if (b.getType() == Material.OBSIDIAN && !Values.NETHER_PORTAL.getBoolean()) {
                e.setCancelled(true);
            }
            if (b.getType() == Material.ENDER_PORTAL_FRAME && !Values.END_PORTAL.getBoolean()) {
                e.setCancelled(true);
            }
        });
    }
}

