/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.events.server.game;

import eu.scorpionltd.uhc.UHC;
import eu.scorpionltd.uhc.events.custom.player.game.GameWinEvent;
import eu.scorpionltd.uhc.manager.GameManager;
import eu.scorpionltd.uhc.manager.integration.IntegrationManager;
import eu.scorpionltd.uhc.manager.langues.msg.MEnum;
import eu.scorpionltd.uhc.manager.players.UHCPlayer;
import eu.scorpionltd.uhc.manager.players.UHCPlayerManager;
import eu.scorpionltd.uhc.manager.settings.values.Values;
import eu.scorpionltd.uhc.manager.teams.UHCTeam;
import eu.scorpionltd.uhc.util.chat.ChatUtil;
import eu.scorpionltd.uhc.util.chat.color.Colors;
import eu.scorpionltd.uhc.util.chat.color.Prefix;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;

public class WinEvent
implements Listener {
    @EventHandler(priority=EventPriority.HIGH)
    public void onWin(GameWinEvent e) {
        GameManager.finishGame();
        if (e.isCancelled()) {
            return;
        }
        System.out.println("WIN SYSTEM: ACTIVATION");
        List<UHCPlayer> lastPlayers = UHCPlayerManager.getPlayings();
        lastPlayers.removeIf(uhcplayer -> uhcplayer.getPlayer() == null || !uhcplayer.getPlayer().isOnline());
        lastPlayers.forEach(player -> player.getInfos().addWins());
        if (Values.TEAM_FFA.getBoolean()) {
            int kills = 0;
            for (UHCPlayer player2 : lastPlayers) {
                kills += player2.getInfos().getCurrentKills();
            }
            String winners = ChatUtil.getPlayerList(lastPlayers);
            MEnum.EVENTS_FFA_WIN.sendAll(ChatUtil.getPlayerList(lastPlayers), kills);
            IntegrationManager.publishWinners(winners, kills);
            return;
        }
        List<UHCTeam> connectedTeams = UHC.getConnectedTeams();
        if (connectedTeams.isEmpty()) {
            return;
        }
        UHCTeam lastTeam = connectedTeams.get(0);
        Prefix teamPrefix = lastTeam.getPrefix();
        int kills = lastTeam.getTotalKills();
        if (Values.TEAM_RED_VS_BLUE.getBoolean()) {
            String winners = ChatUtil.getPlayerList(lastPlayers);
            if (teamPrefix.getColor() == Colors.BLUE) {
                MEnum.EVENTS_RVB_BLUE_WIN.sendAll(winners, kills, teamPrefix.getTextName());
            } else {
                MEnum.EVENTS_RVB_RED_WIN.sendAll(winners, kills, teamPrefix.getTextName());
            }
            IntegrationManager.publishWinners(winners, kills);
            return;
        }
        String winners = ChatUtil.getPlayerList(new ArrayList<UHCPlayer>(lastTeam.getPlayers()));
        MEnum.EVENTS_TEAM_WIN.sendAll(winners, kills, teamPrefix.getTextName());
        IntegrationManager.publishWinners(winners, kills);
    }
}

