/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.events.server;

import eu.scorpionltd.uhc.manager.game.whitelist.WhitelistManager;
import eu.scorpionltd.uhc.manager.game.whitelist.WhitelistType;
import eu.scorpionltd.uhc.manager.langues.Langue;
import eu.scorpionltd.uhc.manager.langues.msg.MEnum;
import eu.scorpionltd.uhc.manager.players.UHCPlayerManager;
import eu.scorpionltd.uhc.manager.players.config.PlayerInfos;
import eu.scorpionltd.uhc.manager.players.permissions.Permissions;
import eu.scorpionltd.uhc.manager.settings.database.DatabaseManager;
import eu.scorpionltd.uhc.manager.settings.values.Values;
import eu.scorpionltd.uhc.tasks.TimerManager;
import eu.scorpionltd.uhc.util.server.ServerUtil;
import eu.scorpionltd.uhc.util.server.enums.Status;
import eu.scorpionltd.uhc.util.server.whitelist.WhitelistMode;
import eu.scorpionltd.uhc.util.server.whitelist.WhitelistStatus;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerLoginEvent;

public class LoginEvent
implements Listener {
    @EventHandler(priority=EventPriority.NORMAL)
    public void onLogin(PlayerLoginEvent e) {
        Player p = e.getPlayer();
        if (e.getResult() == PlayerLoginEvent.Result.KICK_BANNED) {
            return;
        }
        Status currentStatus = Status.getCurrentStatus();
        if (currentStatus == Status.LAUNCH || currentStatus == Status.RESTART || currentStatus == Status.COOLDOWN) {
            this.kickPlayer(e, currentStatus);
            return;
        }
        DatabaseManager.getDatabase().onPlayerLogin(p.getUniqueId());
        if (currentStatus == Status.IN_GAME || currentStatus == Status.FINISH) {
            if (!Permissions.JOIN_STAFF.hasPerm(p) && !p.isWhitelisted()) {
                if (Values.RULES_LATESCATTER.getBoolean() && !ServerUtil.isGameFull() && TimerManager.hasTimerPVP()) {
                    e.allow();
                    return;
                }
                this.kickPlayer(e, currentStatus);
                return;
            }
            e.allow();
            return;
        }
        if (ServerUtil.isGameFull() && !Permissions.JOIN_STAFF.hasPerm(p)) {
            this.kickPlayerGameFull(e);
            return;
        }
        WhitelistStatus whitelistStatus = WhitelistStatus.getCurrentStatus();
        WhitelistType whitelistType = WhitelistManager.getCurrentWhitelist();
        if (whitelistStatus == WhitelistStatus.CLOSE || whitelistType.getMode() == WhitelistMode.PRIVATE) {
            if (!Permissions.JOIN_STAFF.hasPerm(p) && !p.isWhitelisted()) {
                this.kickPlayer(e, currentStatus);
                return;
            }
            e.allow();
            return;
        }
        if (whitelistStatus == WhitelistStatus.OPEN) {
            if (whitelistType.getMode() == WhitelistMode.PERMISSION && !whitelistType.hasPermissionToJoin(p) && !p.isWhitelisted()) {
                this.kickPlayer(e, currentStatus);
                return;
            }
            e.allow();
            return;
        }
        if (whitelistStatus == WhitelistStatus.PRE_WHITELIST) {
            if (ServerUtil.isPreWhitelistFull()) {
                this.kickPreWhitelistGameFull(e);
                return;
            }
            if (whitelistType.getMode() == WhitelistMode.PERMISSION && !whitelistType.hasPermissionToJoin(p) && !p.isWhitelisted()) {
                this.kickPlayer(e, currentStatus);
                return;
            }
            if (!this.checkPreWL(p) && !p.isWhitelisted()) {
                this.kickPlayer(e, currentStatus);
                return;
            }
            this.removePreWL(p);
            e.allow();
            return;
        }
    }

    private boolean checkPreWL(Player p) {
        UUID playerUUID = p.getUniqueId();
        PlayerInfos info = UHCPlayerManager.getInfos(playerUUID);
        if (info == null) {
            info = new PlayerInfos(playerUUID);
        }
        return info.hasPreWhitelist();
    }

    private void removePreWL(Player p) {
        UUID playerUUID = p.getUniqueId();
        PlayerInfos info = UHCPlayerManager.getInfos(playerUUID);
        if (info == null) {
            info = new PlayerInfos(playerUUID);
        }
        info.removePreWhitelist(1);
        UHCPlayerManager.addPreWhitelistNumber();
    }

    private void kickPlayer(PlayerLoginEvent e, Status status) {
        UUID playerUUID = e.getPlayer().getUniqueId();
        PlayerInfos info = UHCPlayerManager.getInfos(playerUUID);
        if (info == null) {
            info = new PlayerInfos(playerUUID);
        }
        Langue langue = info.getLangue();
        e.disallow(PlayerLoginEvent.Result.KICK_OTHER, status.getMessage().getText(langue, new Object[0]));
    }

    private void kickPlayerGameFull(PlayerLoginEvent e) {
        UUID playerUUID = e.getPlayer().getUniqueId();
        PlayerInfos info = UHCPlayerManager.getInfos(playerUUID);
        if (info == null) {
            info = new PlayerInfos(playerUUID);
        }
        Langue langue = info.getLangue();
        e.disallow(PlayerLoginEvent.Result.KICK_OTHER, MEnum.KICK_GAME_FULL.getText(langue, new Object[0]));
    }

    private void kickPreWhitelistGameFull(PlayerLoginEvent e) {
        UUID playerUUID = e.getPlayer().getUniqueId();
        PlayerInfos info = UHCPlayerManager.getInfos(playerUUID);
        if (info == null) {
            info = new PlayerInfos(playerUUID);
        }
        Langue langue = info.getLangue();
        e.disallow(PlayerLoginEvent.Result.KICK_OTHER, MEnum.KICK_PREWHITELIST_FULL.getText(langue, new Object[0]));
    }
}

