/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.events.server;

import eu.scorpionltd.uhc.UHC;
import eu.scorpionltd.uhc.events.custom.player.chat.GlobalChatEvent;
import eu.scorpionltd.uhc.events.custom.player.chat.TeamChatEvent;
import eu.scorpionltd.uhc.manager.langues.msg.MEnum;
import eu.scorpionltd.uhc.manager.players.UHCPlayer;
import eu.scorpionltd.uhc.manager.players.UHCPlayerManager;
import eu.scorpionltd.uhc.manager.players.permissions.Permissions;
import eu.scorpionltd.uhc.manager.settings.values.Values;
import eu.scorpionltd.uhc.manager.teams.UHCTeam;
import eu.scorpionltd.uhc.tasks.TimerManager;
import eu.scorpionltd.uhc.util.chat.ChatUtil;
import eu.scorpionltd.uhc.util.server.enums.Status;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;

public class ChatEvent
implements Listener {
    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onChatEvent(AsyncPlayerChatEvent e) {
        if (e.getMessage() == null || e.getPlayer() == null) {
            return;
        }
        Player p = e.getPlayer();
        UHCPlayer up = UHCPlayerManager.getPlayer(p.getUniqueId());
        String message = e.getMessage();
        String name = up.getName();
        if (!Status.getCurrentStatus().isStart() || Values.CHAT_SEE_GAME_RANKS.getBoolean()) {
            name = up.getRankName();
        }
        e.setCancelled(true);
        if (ChatUtil.isMuteChat() && !Permissions.BYPASS_MUTE_ALL.hasPerm(p) && !this.isTeamChat(up, message)) {
            MEnum.BLOCKED_MESSAGES.sendTo(p, new Object[0]);
            return;
        }
        if (up.isSpec()) {
            MEnum.SPEC_MESSAGE.sendAll(name, message);
            System.out.println("(SPEC) " + name + ": " + message);
            return;
        }
        boolean isPlaying = up.isPlaying();
        if (up.isHost() && !isPlaying) {
            if (message.startsWith("!")) {
                message = message.replaceFirst("!", "");
            } else if (message.startsWith("@")) {
                message = message.replaceFirst("@", "");
            }
            MEnum.HOST_MESSAGE.sendAll(name, message);
            System.out.println("(HOST) " + name + ": " + message);
            return;
        }
        if (up.isDead() || !isPlaying) {
            if (Values.CHAT_SEE_DEAD_MESSAGE.getBoolean()) {
                MEnum.DEAD_MESSAGE.sendAll(name, message);
            } else {
                MEnum.DEAD_MESSAGE.sendDeads(name, message);
            }
            System.out.println("(DEAD) " + name + ": " + message);
            return;
        }
        if (this.isTeamChat(up, message)) {
            Bukkit.getPluginManager().callEvent((Event)new TeamChatEvent(up, UHC.getTeam(up), name, message));
        } else {
            UHCTeam uhcTeam;
            if (Values.TEAM_SHOW_PREFIX.getBoolean() && (uhcTeam = UHC.getTeam(up)) != null) {
                name = uhcTeam.getPrefix().getPrefixName() + up.getName();
            }
            if (message.startsWith("!")) {
                message = message.replaceFirst("!", "");
            } else if (message.startsWith("@")) {
                message = message.replaceFirst("@", "");
            }
            Bukkit.getPluginManager().callEvent((Event)new GlobalChatEvent(up, name, message));
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onTeamChat(TeamChatEvent e) {
        if (e.isCancelled()) {
            return;
        }
        MEnum.TEAM_MESSAGE.sendTeam(e.geetTeam(), e.getPlayerName(), e.getMessage());
        System.out.println("(TEAM) " + e.getPlayerName() + ": " + e.getMessage());
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onGlobalChat(GlobalChatEvent e) {
        if (e.isCancelled()) {
            return;
        }
        int globalChat = Values.CHAT_GLOBAL_MESSAGE.getInteger();
        if (Status.getCurrentStatus() == Status.IN_GAME && e.getPlayer().isPlaying() && globalChat != 4 && (globalChat == 0 || globalChat == 3 && !TimerManager.hasTimerMeetup() || globalChat == 2 && !TimerManager.hasTimerPVP() || globalChat == 1 && !TimerManager.hasTimerFinalHeal())) {
            e.setCancelled(true);
            MEnum.BLOCKED_MESSAGES.send(e.getPlayer(), new Object[0]);
            return;
        }
        MEnum.GLOBAL_MESSAGE.sendAll(e.getPlayerName(), e.getMessage());
        System.out.println("(GLOBAL) " + e.getPlayerName() + ": " + e.getMessage());
    }

    private boolean isTeamChat(UHCPlayer up, String message) {
        return Status.getCurrentStatus().isStart() && Values.CHAT_TEAM_MESSAGE.getBoolean() && UHC.getTeam(up) != null && !message.startsWith("!") && !message.startsWith("@");
    }
}

