/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.events.scenario.pvp;

import eu.scorpionltd.listeners.EventManager;
import eu.scorpionltd.uhc.UHC;
import eu.scorpionltd.uhc.events.custom.player.GameDeathEvent;
import eu.scorpionltd.uhc.events.player.rules.StealEvent;
import eu.scorpionltd.uhc.manager.langues.msg.MEnum;
import eu.scorpionltd.uhc.manager.langues.msg.UHCMessage;
import eu.scorpionltd.uhc.manager.scenarios.Scenario;
import eu.scorpionltd.uhc.manager.scenarios.ScenarioCategorie;
import eu.scorpionltd.uhc.manager.settings.Settings;
import eu.scorpionltd.uhc.manager.settings.config.ConfigFile;
import eu.scorpionltd.uhc.manager.settings.values.ValueCategorie;
import eu.scorpionltd.uhc.manager.settings.values.Values;
import eu.scorpionltd.uhc.ui.config.MenuScenarios;
import eu.scorpionltd.uhc.util.entity.EntityUtil;
import eu.scorpionltd.uhc.util.player.InventoryUtil;
import eu.scorpionltd.uhc.util.server.enums.Metadata;
import eu.scorpionltd.utils.inventory.CustomInventory;
import eu.scorpionltd.utils.item.Item;
import eu.scorpionltd.utils.player.ScorpionPlayer;
import eu.scorpionltd.utils.variable.Variable;
import eu.scorpionltd.utils.variable.list.VariableInteger;
import java.util.List;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Chest;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class TimeBomb
extends Scenario
implements Listener {
    private Settings timeChest = new Settings(ValueCategorie.SCENARIO, (Variable)new VariableInteger("scenario.timebomb.timeChest", new ItemStack(Material.CHEST), 30, 1, Integer.MAX_VALUE, 1, 2, 5));
    private UHCMessage explosionMessage = new UHCMessage("scenario.timebomb.explosionMessage");
    private UHCMessage explosionBoom = new UHCMessage("scenario.timebomb.explosionBoom");

    public TimeBomb() {
        super("TimeBomb", ScenarioCategorie.PVP, new ItemStack(Material.CHEST));
    }

    @Override
    public void onEnable(ScorpionPlayer sp) {
        Values.RULES_HEAD_POST.getSettings().changeValue(sp, false);
        Values.RULES_HEAD.getSettings().changeValue(sp, true);
    }

    @Override
    public void onDisable(ScorpionPlayer sp) {
        Values.RULES_HEAD_POST.getSettings().changeValue(sp, true);
        Values.RULES_HEAD.getSettings().changeValue(sp, false);
    }

    @Override
    public void onStart() {
        EventManager.registerEvent((Listener)this, (Plugin)UHC.getInstance());
    }

    @Override
    public void onConfigMenu(ScorpionPlayer p) {
        new ConfigScenarioInventory(p).openMenu();
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onDeath(GameDeathEvent e) {
        this.setupTimeBomb(e.getDeath().getPlayer(), e.getDeathEvent().getDrops());
        e.getDeathEvent().getDrops().clear();
    }

    private void setupTimeBomb(final Player player, List<ItemStack> drops) {
        Location loc = player.getLocation();
        final Block b = loc.getBlock();
        final Block b1 = loc.add(0.0, 0.0, 1.0).getBlock();
        b.setType(Material.CHEST);
        b1.setType(Material.CHEST);
        Metadata.NO_BREAKING.add(b);
        Metadata.NO_BREAKING.add(b1);
        UUID uuid = player.getUniqueId();
        StealEvent.addPlacedBlock(uuid, b);
        StealEvent.addPlacedBlock(uuid, b1);
        final Chest chest = (Chest)loc.getBlock().getState();
        InventoryUtil.fillInventory(chest.getInventory(), drops);
        chest.update();
        final ArmorStand ar = EntityUtil.getArmorStand(new Location(chest.getWorld(), (double)chest.getX(), (double)chest.getY() + 0.75, (double)chest.getZ()));
        new BukkitRunnable(){
            int time;
            {
                this.time = (Integer)TimeBomb.this.timeChest.getValue();
            }

            public void run() {
                if (this.time < 0) {
                    ar.remove();
                    this.cancel();
                    return;
                }
                if (this.time == 0) {
                    ar.setCustomName(TimeBomb.this.explosionBoom.getText(player, new Object[0]));
                    if (chest.getBlock().getType() == Material.CHEST) {
                        chest.getInventory().clear();
                        chest.update();
                    }
                    Metadata.NO_BREAKING.remove(b);
                    Metadata.NO_BREAKING.remove(b1);
                    chest.getLocation().getWorld().createExplosion(chest.getLocation(), 5.0f);
                    --this.time;
                    return;
                }
                ar.setCustomName(TimeBomb.this.explosionMessage.getText(player, this.time));
                --this.time;
            }
        }.runTaskTimer((Plugin)UHC.getInstance(), 0L, 20L);
    }

    private class ConfigScenarioInventory
    extends CustomInventory {
        public ConfigScenarioInventory(ScorpionPlayer sp) {
            super(sp, MEnum.MENU_CONFIG_SCENARIO.getText(sp, TimeBomb.this.getName()), 3, 1);
        }

        public void setupMenu() {
            this.remplirInventory(new Item(Material.STAINED_GLASS_PANE, ConfigFile.UI_COLOR_SCENARIO.getColor(), " ").toItemStack());
            this.addReturnItem(9, new MenuScenarios(this.player, 1), MEnum.RETURN_MENU.getText(this.player, new Object[0]));
            this.addCloseItem(17, MEnum.CLOSE_MENU.getText(this.player, new Object[0]));
            TimeBomb.this.timeChest.addSimpleNumberModifier(this, 1, 13, false, null);
        }
    }
}

