/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.events.scenario.minage;

import eu.scorpionltd.listeners.EventManager;
import eu.scorpionltd.uhc.UHC;
import eu.scorpionltd.uhc.manager.langues.msg.MEnum;
import eu.scorpionltd.uhc.manager.scenarios.Scenario;
import eu.scorpionltd.uhc.manager.scenarios.ScenarioCategorie;
import eu.scorpionltd.uhc.manager.settings.Settings;
import eu.scorpionltd.uhc.manager.settings.config.ConfigFile;
import eu.scorpionltd.uhc.manager.settings.values.ValueCategorie;
import eu.scorpionltd.uhc.ui.config.MenuScenarios;
import eu.scorpionltd.utils.inventory.CustomInventory;
import eu.scorpionltd.utils.item.Item;
import eu.scorpionltd.utils.player.ScorpionPlayer;
import eu.scorpionltd.utils.variable.Variable;
import eu.scorpionltd.utils.variable.list.VariableInteger;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class HasteyBoys
extends Scenario
implements Listener {
    private Settings efficiency = new Settings(ValueCategorie.SCENARIO, (Variable)new VariableInteger("scenario.hasteyboys.efficiency", new ItemStack(Material.DIAMOND_PICKAXE), 3, 0, Integer.MAX_VALUE, 1, 2, 3));
    private Settings unbreaking = new Settings(ValueCategorie.SCENARIO, (Variable)new VariableInteger("scenario.hasteyboys.unbreaking", new ItemStack(Material.STONE), 2, 0, Integer.MAX_VALUE, 1, 2, 3));

    public HasteyBoys() {
        super("HasteyBoys", ScenarioCategorie.MINAGE, new ItemStack(Material.GOLD_PICKAXE));
    }

    @Override
    public void onStart() {
        EventManager.registerEvent((Listener)this, (Plugin)UHC.getInstance());
    }

    @Override
    public void onConfigMenu(ScorpionPlayer p) {
        new ConfigScenarioInventory(p).openMenu();
    }

    @EventHandler
    public void onCraft(CraftItemEvent e) {
        if (e.getCurrentItem() == null || e.getCurrentItem().getType() == null) {
            return;
        }
        if (this.isUpgradeItem(e.getCurrentItem().getType()).booleanValue()) {
            e.setCurrentItem(this.enchantAndUpgrade(e.getCurrentItem()));
        }
    }

    public Boolean isUpgradeItem(Material type) {
        return type == Material.WOOD_AXE || type == Material.WOOD_PICKAXE || type == Material.WOOD_SPADE || type == Material.GOLD_AXE || type == Material.GOLD_PICKAXE || type == Material.GOLD_SPADE || type == Material.STONE_AXE || type == Material.STONE_PICKAXE || type == Material.STONE_SPADE || type == Material.IRON_AXE || type == Material.IRON_PICKAXE || type == Material.IRON_SPADE || type == Material.DIAMOND_AXE || type == Material.DIAMOND_PICKAXE || type == Material.DIAMOND_SPADE;
    }

    public ItemStack enchantAndUpgrade(ItemStack item) {
        VariableInteger varEfficiency = (VariableInteger)this.efficiency.getVariable();
        VariableInteger varUnbreaking = (VariableInteger)this.unbreaking.getVariable();
        if (varEfficiency.getValue() > 0) {
            item.addUnsafeEnchantment(Enchantment.DIG_SPEED, varEfficiency.getValue());
        }
        if (varUnbreaking.getValue() > 0) {
            item.addUnsafeEnchantment(Enchantment.DURABILITY, varUnbreaking.getValue());
        }
        return item;
    }

    private class ConfigScenarioInventory
    extends CustomInventory {
        public ConfigScenarioInventory(ScorpionPlayer sp) {
            super(sp, MEnum.MENU_CONFIG_SCENARIO.getText(sp, HasteyBoys.this.getName()), 3, 1);
        }

        public void setupMenu() {
            this.remplirInventory(new Item(Material.STAINED_GLASS_PANE, ConfigFile.UI_COLOR_SCENARIO.getColor(), " ").toItemStack());
            this.addReturnItem(9, new MenuScenarios(this.player, 1), MEnum.RETURN_MENU.getText(this.player, new Object[0]));
            this.addCloseItem(17, MEnum.CLOSE_MENU.getText(this.player, new Object[0]));
            HasteyBoys.this.efficiency.addSimpleNumberModifier(this, 1, 4, false, null);
            HasteyBoys.this.unbreaking.addSimpleNumberModifier(this, 1, 22, false, null);
        }
    }
}

