/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.events.scenario.minage;

import eu.scorpionltd.listeners.EventManager;
import eu.scorpionltd.uhc.UHC;
import eu.scorpionltd.uhc.manager.langues.msg.MEnum;
import eu.scorpionltd.uhc.manager.scenarios.Scenario;
import eu.scorpionltd.uhc.manager.scenarios.ScenarioCategorie;
import eu.scorpionltd.uhc.manager.settings.Settings;
import eu.scorpionltd.uhc.manager.settings.config.ConfigFile;
import eu.scorpionltd.uhc.manager.settings.values.ValueCategorie;
import eu.scorpionltd.uhc.ui.config.MenuScenarios;
import eu.scorpionltd.utils.inventory.CustomInventory;
import eu.scorpionltd.utils.item.Item;
import eu.scorpionltd.utils.player.ScorpionPlayer;
import eu.scorpionltd.utils.variable.Variable;
import eu.scorpionltd.utils.variable.list.VariableInteger;
import org.bukkit.Material;
import org.bukkit.block.Furnace;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.FurnaceBurnEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class FastSmelting
extends Scenario
implements Listener {
    private Settings speed = new Settings(ValueCategorie.SCENARIO, (Variable)new VariableInteger("scenario.fastsmelting.speed", new ItemStack(Material.FURNACE), 4, 1, Integer.MAX_VALUE, 1, 2, 5));

    public FastSmelting() {
        super("FastSmelting", ScenarioCategorie.MINAGE, new ItemStack(Material.FURNACE));
    }

    @Override
    public void onStart() {
        EventManager.registerEvent((Listener)this, (Plugin)UHC.getInstance());
    }

    @Override
    public void onConfigMenu(ScorpionPlayer p) {
        new ConfigScenarioInventory(p).openMenu();
    }

    @EventHandler
    public void onFurnaceBurn(FurnaceBurnEvent e) {
        if (e.getBlock() == null) {
            return;
        }
        this.startUpdate((Furnace)e.getBlock().getState(), (Integer)this.speed.getValue());
    }

    private void startUpdate(final Furnace block, final int speed) {
        new BukkitRunnable(){

            public void run() {
                if (block == null) {
                    this.cancel();
                    return;
                }
                if (block.getCookTime() <= 0 && block.getBurnTime() <= 0) {
                    block.setCookTime((short)0);
                    block.update();
                    this.cancel();
                    return;
                }
                block.setCookTime((short)(block.getCookTime() + speed));
                block.update();
            }
        }.runTaskTimer((Plugin)UHC.getInstance(), 1L, 1L);
    }

    private class ConfigScenarioInventory
    extends CustomInventory {
        public ConfigScenarioInventory(ScorpionPlayer sp) {
            super(sp, MEnum.MENU_CONFIG_SCENARIO.getText(sp, FastSmelting.this.getName()), 3, 1);
        }

        public void setupMenu() {
            this.remplirInventory(new Item(Material.STAINED_GLASS_PANE, ConfigFile.UI_COLOR_SCENARIO.getColor(), " ").toItemStack());
            this.addReturnItem(9, new MenuScenarios(this.player, 1), MEnum.RETURN_MENU.getText(this.player, new Object[0]));
            FastSmelting.this.speed.addSimpleNumberModifier(this, 1, 13, false, null);
            this.addCloseItem(17, MEnum.CLOSE_MENU.getText(this.player, new Object[0]));
        }
    }
}

