/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.events.scenario.minage;

import eu.scorpionltd.listeners.EventManager;
import eu.scorpionltd.uhc.UHC;
import eu.scorpionltd.uhc.manager.langues.msg.MEnum;
import eu.scorpionltd.uhc.manager.langues.msg.UHCMessage;
import eu.scorpionltd.uhc.manager.scenarios.Scenario;
import eu.scorpionltd.uhc.manager.scenarios.ScenarioCategorie;
import eu.scorpionltd.uhc.manager.settings.Settings;
import eu.scorpionltd.uhc.manager.settings.config.ConfigFile;
import eu.scorpionltd.uhc.manager.settings.values.ValueCategorie;
import eu.scorpionltd.uhc.ui.config.MenuScenarios;
import eu.scorpionltd.uhc.util.player.EffectUtil;
import eu.scorpionltd.utils.inventory.CustomInventory;
import eu.scorpionltd.utils.item.Item;
import eu.scorpionltd.utils.player.ScorpionPlayer;
import eu.scorpionltd.utils.variable.Variable;
import eu.scorpionltd.utils.variable.list.VariableInteger;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class BloodDiamond
extends Scenario
implements Listener {
    private Settings healthTaken = new Settings(ValueCategorie.SCENARIO, (Variable)new VariableInteger("scenario.blooddiamond.healthtaken", new ItemStack(Material.APPLE), 1, 1, Integer.MAX_VALUE, 1, 2, 3));
    private UHCMessage breakMessage = new UHCMessage("scenario.blooddiamond.breakMessage");

    public BloodDiamond() {
        super("BloodDiamond", ScenarioCategorie.MINAGE, new ItemStack(Material.DIAMOND_ORE));
    }

    @Override
    public void onStart() {
        EventManager.registerEvent((Listener)this, (Plugin)UHC.getInstance());
    }

    @Override
    public void onConfigMenu(ScorpionPlayer p) {
        new ConfigScenarioInventory(p).openMenu();
    }

    @EventHandler(ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent e) {
        if (e.getPlayer() == null || e.getBlock() == null || e.getBlock().getType() != Material.DIAMOND_ORE) {
            return;
        }
        Player p = e.getPlayer();
        this.breakMessage.sendTo(p, this.healthTaken.getTextValue(ScorpionPlayer.getScorpionPlayer((Player)p)));
        EffectUtil.damage(p, ((Integer)this.healthTaken.getValue()).intValue());
    }

    private class ConfigScenarioInventory
    extends CustomInventory {
        public ConfigScenarioInventory(ScorpionPlayer sp) {
            super(sp, MEnum.MENU_CONFIG_SCENARIO.getText(sp, BloodDiamond.this.getName()), 3, 1);
        }

        public void setupMenu() {
            this.remplirInventory(new Item(Material.STAINED_GLASS_PANE, ConfigFile.UI_COLOR_SCENARIO.getColor(), " ").toItemStack());
            this.addReturnItem(9, new MenuScenarios(this.player, 1), MEnum.RETURN_MENU.getText(this.player, new Object[0]));
            this.addCloseItem(17, MEnum.CLOSE_MENU.getText(this.player, new Object[0]));
            BloodDiamond.this.healthTaken.addSimpleNumberModifier(this, 1, 13, false, null);
        }
    }
}

