/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.events.scenario.effets;

import eu.scorpionltd.listeners.EventManager;
import eu.scorpionltd.uhc.UHC;
import eu.scorpionltd.uhc.events.custom.player.GameReviveEvent;
import eu.scorpionltd.uhc.manager.langues.msg.MEnum;
import eu.scorpionltd.uhc.manager.langues.msg.UHCMessage;
import eu.scorpionltd.uhc.manager.players.UHCPlayer;
import eu.scorpionltd.uhc.manager.players.UHCPlayerManager;
import eu.scorpionltd.uhc.manager.scenarios.Scenario;
import eu.scorpionltd.uhc.manager.scenarios.ScenarioCategorie;
import eu.scorpionltd.uhc.manager.settings.Settings;
import eu.scorpionltd.uhc.manager.settings.config.ConfigFile;
import eu.scorpionltd.uhc.manager.settings.values.ValueCategorie;
import eu.scorpionltd.uhc.manager.settings.values.Values;
import eu.scorpionltd.uhc.manager.teams.UHCTeam;
import eu.scorpionltd.uhc.ui.config.MenuScenarios;
import eu.scorpionltd.uhc.util.player.EffectUtil;
import eu.scorpionltd.uhc.util.server.enums.Metadata;
import eu.scorpionltd.utils.inventory.CustomInventory;
import eu.scorpionltd.utils.item.Item;
import eu.scorpionltd.utils.player.ScorpionPlayer;
import eu.scorpionltd.utils.variable.Variable;
import eu.scorpionltd.utils.variable.list.VariableBoolean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffectType;

public class SuperHeroes
extends Scenario
implements Listener {
    private UHCMessage powerMessage;
    private List<Settings> powers;
    private Settings oneEffectByTeam;
    private HashMap<UHCTeam, List<Settings>> teamEffects = new HashMap();
    private HashMap<UUID, Settings> playerPower = new HashMap();

    public SuperHeroes() {
        super("SuperHeroes", ScenarioCategorie.EFFETS, new ItemStack(Material.LAPIS_BLOCK));
        this.powerMessage = new UHCMessage("scenario.superheroes.powerMessage");
        this.oneEffectByTeam = new Settings(ValueCategorie.SCENARIO, (Variable)new VariableBoolean("scenario.superheroes.oneEffectByTeam", new ItemStack(Material.BANNER), false));
        this.powers = new ArrayList<Settings>();
        this.powers.add(new Settings(ValueCategorie.SCENARIO, (Variable)new VariableBoolean("scenario.superheroes.speed2", new ItemStack(Material.IRON_BOOTS), true)));
        this.powers.add(new Settings(ValueCategorie.SCENARIO, (Variable)new VariableBoolean("scenario.superheroes.strength1", new ItemStack(Material.IRON_SWORD), true)));
        this.powers.add(new Settings(ValueCategorie.SCENARIO, (Variable)new VariableBoolean("scenario.superheroes.resistance2", new ItemStack(Material.DIAMOND_CHESTPLATE), true)));
        this.powers.add(new Settings(ValueCategorie.SCENARIO, (Variable)new VariableBoolean("scenario.superheroes.resistance1fire1", new ItemStack(Material.CHAINMAIL_CHESTPLATE), false)));
        this.powers.add(new Settings(ValueCategorie.SCENARIO, (Variable)new VariableBoolean("scenario.superheroes.jump4", new ItemStack(Material.FEATHER), true)));
        this.powers.add(new Settings(ValueCategorie.SCENARIO, (Variable)new VariableBoolean("scenario.superheroes.haste2saturation", new ItemStack(Material.IRON_PICKAXE), false)));
        this.powers.add(new Settings(ValueCategorie.SCENARIO, (Variable)new VariableBoolean("scenario.superheroes.hearths10", new ItemStack(Material.GOLDEN_APPLE), true)));
        this.powers.add(new Settings(ValueCategorie.SCENARIO, (Variable)new VariableBoolean("scenario.superheroes.hearths6", new ItemStack(Material.APPLE), false)));
    }

    @Override
    public void onEnable(ScorpionPlayer sp) {
        Values.NETHER_ACCESS.getSettings().changeValue(sp, false);
        Values.ITEM_MILK_BUCKET.getSettings().changeValue(sp, false);
    }

    @Override
    public List<String> onProfileInformations(ScorpionPlayer sp, UHCPlayer player) {
        List<String> infos = super.onProfileInformations(sp, player);
        UUID uuid = player.getUUID();
        if (this.playerPower.containsKey(uuid)) {
            infos.add(ChatColor.GOLD + "SuperHeroes " + ChatColor.DARK_GRAY + ">" + ChatColor.GRAY + " Effect: " + ChatColor.LIGHT_PURPLE + this.playerPower.get(uuid).getName(player.getScorpionPlayer()));
        }
        return infos;
    }

    @Override
    public void onConfigMenu(ScorpionPlayer p) {
        new ConfigScenarioInventory(p).openMenu();
    }

    @Override
    public void onStart() {
        boolean oneEffectByTeam = (Boolean)this.oneEffectByTeam.getValue();
        UHCPlayerManager.getPlayingsPlayer().forEach(player -> this.chooseEffect((Player)player, oneEffectByTeam));
        EventManager.registerEvent((Listener)this, (Plugin)UHC.getInstance());
    }

    @EventHandler
    public void onGameRevive(GameReviveEvent e) {
        Player player = e.getRevivePlayer().getPlayer();
        UUID uuid = player.getUniqueId();
        if (this.playerPower.containsKey(uuid)) {
            this.giveEffect(player, this.playerPower.get(uuid));
            return;
        }
        this.chooseEffect(e.getRevivePlayer().getPlayer(), (Boolean)this.oneEffectByTeam.getValue());
    }

    private void chooseEffect(Player player, boolean isOneEffectByTeam) {
        List<Settings> activatedPowers = this.getActivatedPowers();
        UHCTeam team = UHC.getTeam(player);
        if (team != null && isOneEffectByTeam) {
            if (!this.teamEffects.containsKey(team)) {
                this.teamEffects.put(team, activatedPowers);
            }
            activatedPowers = this.teamEffects.get(team);
        }
        Settings power = activatedPowers.remove(new Random().nextInt(activatedPowers.size()));
        this.playerPower.put(player.getUniqueId(), power);
        this.giveEffect(player, power);
        ScorpionPlayer sp = ScorpionPlayer.getScorpionPlayer((Player)player);
        this.powerMessage.sendTo(sp, power.getName(sp));
    }

    private void giveEffect(Player player, Settings power) {
        switch (power.getVariable().getItemStack().getType()) {
            case IRON_BOOTS: {
                EffectUtil.giveInfiniteEffect(player, PotionEffectType.SPEED, 2);
                break;
            }
            case IRON_SWORD: {
                EffectUtil.giveInfiniteEffect(player, PotionEffectType.INCREASE_DAMAGE, 1);
                break;
            }
            case DIAMOND_CHESTPLATE: {
                EffectUtil.giveInfiniteEffect(player, PotionEffectType.DAMAGE_RESISTANCE, 2);
                break;
            }
            case CHAINMAIL_CHESTPLATE: {
                EffectUtil.giveInfiniteEffect(player, PotionEffectType.DAMAGE_RESISTANCE, 1);
                EffectUtil.giveInfiniteEffect(player, PotionEffectType.FIRE_RESISTANCE, 1);
                break;
            }
            case FEATHER: {
                EffectUtil.giveInfiniteEffect(player, PotionEffectType.JUMP, 4);
                Metadata.NO_FALL.add(player);
                break;
            }
            case IRON_PICKAXE: {
                EffectUtil.giveInfiniteEffect(player, PotionEffectType.FAST_DIGGING, 2);
                EffectUtil.giveInfiniteEffect(player, PotionEffectType.SATURATION, 1);
                break;
            }
            case GOLDEN_APPLE: {
                EffectUtil.addMaxHealth(player, 10, true);
                break;
            }
            case APPLE: {
                EffectUtil.addMaxHealth(player, 6, true);
            }
        }
    }

    private List<Settings> getActivatedPowers() {
        return new ArrayList<Settings>(this.powers.stream().filter(power -> (Boolean)power.getValue()).collect(Collectors.toList()));
    }

    private class ConfigScenarioInventory
    extends CustomInventory {
        public ConfigScenarioInventory(ScorpionPlayer sp) {
            super(sp, MEnum.MENU_CONFIG_SCENARIO.getText(sp, SuperHeroes.this.getName()), 3, 1);
        }

        public void setupMenu() {
            ItemStack glass = new Item(Material.STAINED_GLASS_PANE, ConfigFile.UI_COLOR_SCENARIO.getColor(), " ").toItemStack();
            this.remplirLignesInventory(glass, 1);
            this.remplirLignesInventory(glass, 2);
            this.addReturnItem(0, new MenuScenarios(this.player, 1), MEnum.RETURN_MENU.getText(this.player, new Object[0]));
            SuperHeroes.this.oneEffectByTeam.addItem(this, 4);
            this.addCloseItem(8, MEnum.CLOSE_MENU.getText(this.player, new Object[0]));
            int slot = 18;
            for (Settings power : SuperHeroes.this.powers) {
                power.addItem(this, slot);
                ++slot;
            }
        }
    }
}

