/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.events.scenario;

import eu.scorpionltd.listeners.EventManager;
import eu.scorpionltd.uhc.UHC;
import eu.scorpionltd.uhc.manager.langues.msg.MEnum;
import eu.scorpionltd.uhc.manager.scenarios.Scenario;
import eu.scorpionltd.uhc.manager.scenarios.ScenarioCategorie;
import eu.scorpionltd.uhc.manager.settings.Settings;
import eu.scorpionltd.uhc.manager.settings.config.ConfigFile;
import eu.scorpionltd.uhc.manager.settings.values.ValueCategorie;
import eu.scorpionltd.uhc.ui.config.MenuScenarios;
import eu.scorpionltd.uhc.util.world.BlockUtil;
import eu.scorpionltd.utils.inventory.CustomInventory;
import eu.scorpionltd.utils.item.Item;
import eu.scorpionltd.utils.player.ScorpionPlayer;
import eu.scorpionltd.utils.variable.Variable;
import eu.scorpionltd.utils.variable.list.VariableInteger;
import java.util.ArrayList;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Timber
extends Scenario
implements Listener {
    private Settings delayPeriod = new Settings(ValueCategorie.SCENARIO, (Variable)new VariableInteger("scenario.timber.delayPeriod", new ItemStack(Material.IRON_AXE), 2, 0, 20, 1, 2, 5));

    public Timber() {
        super("Timber", ScenarioCategorie.WORLD, new ItemStack(Material.LOG));
    }

    @Override
    public void onStart() {
        EventManager.registerEvent((Listener)this, (Plugin)UHC.getInstance());
    }

    @Override
    public void onConfigMenu(ScorpionPlayer p) {
        new ConfigScenarioInventory(p).openMenu();
    }

    public int getDelayPeriod() {
        return (Integer)this.delayPeriod.getValue();
    }

    @EventHandler(ignoreCancelled=true)
    public void onBreak(BlockBreakEvent e) {
        Material mat = e.getBlock().getType();
        if (mat == Material.LOG || mat == Material.LOG_2) {
            final ArrayList<Block> bList = new ArrayList<Block>();
            bList.add(e.getBlock());
            e.setCancelled(true);
            for (BlockFace face : BlockFace.values()) {
                if (e.getBlock().getRelative(face).getType() != Material.LOG && e.getBlock().getRelative(face).getType() != Material.LOG_2) continue;
                bList.add(e.getBlock().getRelative(face));
            }
            new BukkitRunnable(){

                public void run() {
                    Block block = (Block)bList.remove(0);
                    for (BlockFace face : BlockFace.values()) {
                        if (block.getRelative(face).getType() != Material.LOG && block.getRelative(face).getType() != Material.LOG_2) continue;
                        bList.add(block.getRelative(face));
                    }
                    BlockUtil.breakBlock(block);
                    if (bList.isEmpty()) {
                        this.cancel();
                        return;
                    }
                }
            }.runTaskTimer((Plugin)UHC.getInstance(), 0L, (long)this.getDelayPeriod());
        }
    }

    private class ConfigScenarioInventory
    extends CustomInventory {
        public ConfigScenarioInventory(ScorpionPlayer sp) {
            super(sp, MEnum.MENU_CONFIG_SCENARIO.getText(sp, Timber.this.getName()), 3, 1);
        }

        public void setupMenu() {
            this.remplirInventory(new Item(Material.STAINED_GLASS_PANE, ConfigFile.UI_COLOR_SCENARIO.getColor(), " ").toItemStack());
            this.addReturnItem(9, new MenuScenarios(this.player, 1), MEnum.RETURN_MENU.getText(this.player, new Object[0]));
            this.addCloseItem(17, MEnum.CLOSE_MENU.getText(this.player, new Object[0]));
            Timber.this.delayPeriod.addSimpleNumberModifier(this, 1, 13, false, null);
        }
    }
}

