/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.events.scenario;

import eu.scorpionltd.listeners.EventManager;
import eu.scorpionltd.uhc.UHC;
import eu.scorpionltd.uhc.events.custom.item.GameInteractEvent;
import eu.scorpionltd.uhc.events.custom.player.GameDeathEvent;
import eu.scorpionltd.uhc.events.custom.player.connexion.GameKickEvent;
import eu.scorpionltd.uhc.manager.langues.msg.UHCMessage;
import eu.scorpionltd.uhc.manager.players.UHCPlayer;
import eu.scorpionltd.uhc.manager.scenarios.Scenario;
import eu.scorpionltd.uhc.manager.scenarios.ScenarioCategorie;
import eu.scorpionltd.uhc.manager.teams.UHCTeam;
import eu.scorpionltd.utils.player.ScorpionPlayer;
import eu.scorpionltd.utils.task.Cooldown;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class AssaultBattery
extends Scenario
implements Listener {
    private UHCMessage jokerMessage = new UHCMessage("scenario.assaultbattery.jokerMessage");
    private UHCMessage assaultMessage = new UHCMessage("scenario.assaultbattery.assaultMessage");
    private UHCMessage batteryMessage = new UHCMessage("scenario.assaultbattery.batteryMessage");
    private UHCMessage assaultBlocked = new UHCMessage("scenario.assaultbattery.assaultBlocked");
    private UHCMessage batteryBlocked = new UHCMessage("scenario.assaultbattery.batteryBlocked");
    private List<UUID> assaults;
    private List<UUID> batterys;

    public AssaultBattery() {
        super("Assault&Battery", ScenarioCategorie.TEAMS, new ItemStack(Material.LOG));
    }

    @Override
    public void onStart() {
        EventManager.registerEvent((Listener)this, (Plugin)UHC.getInstance());
        this.assaults = new ArrayList<UUID>();
        this.batterys = new ArrayList<UUID>();
        new Cooldown(5){

            public void onFinish() {
                AssaultBattery.this.setupAssaultAndBattery();
            }
        };
    }

    @Override
    public List<String> onProfileInformations(ScorpionPlayer sp, UHCPlayer player) {
        List<String> infos = super.onProfileInformations(sp, player);
        UUID uuid = player.getUUID();
        String roleName = "Joker";
        if (this.assaults.contains(uuid)) {
            roleName = "Assault";
        }
        if (this.batterys.contains(uuid)) {
            roleName = "Battery";
        }
        infos.add(ChatColor.GOLD + "Assault&Battery " + ChatColor.DARK_GRAY + ">" + ChatColor.AQUA + roleName);
        return infos;
    }

    private void setupAssaultAndBattery() {
        for (UHCTeam team : UHC.getTeams()) {
            if (team.getAlivePlayers().size() <= 0) continue;
            List players = team.getAlivePlayers().stream().filter(player -> player.getPlayer() != null).collect(Collectors.toList());
            if (players.size() == 1) {
                this.setJoker((UHCPlayer)players.get(0));
                continue;
            }
            if (players.size() <= 1) continue;
            this.setAssault((UHCPlayer)players.remove(new Random().nextInt(players.size())));
            this.setBattery((UHCPlayer)players.get(0));
        }
    }

    private void setJoker(UHCPlayer p) {
        UUID uuid = p.getUUID();
        if (this.assaults.contains(uuid)) {
            this.assaults.remove(uuid);
        }
        if (this.batterys.contains(uuid)) {
            this.batterys.remove(uuid);
        }
        this.jokerMessage.send(p, new Object[0]);
    }

    private void setAssault(UHCPlayer p) {
        this.assaults.add(p.getUUID());
        this.assaultMessage.send(p, new Object[0]);
    }

    private void setBattery(UHCPlayer p) {
        this.batterys.add(p.getUUID());
        this.batteryMessage.send(p, new Object[0]);
    }

    @EventHandler
    public void onInteract(GameInteractEvent e) {
        if (e.getItem() == null || e.getUHCPlayer().getPlayer() == null || e.getItem().getType() == null) {
            return;
        }
        Player p = e.getUHCPlayer().getPlayer();
        Material result = e.getItem().getType();
        if (this.assaults.contains(p.getUniqueId()) && (result == Material.BOW || result == Material.EGG || result == Material.SNOW_BALL || result == Material.FISHING_ROD)) {
            e.setCancelled(true);
            this.assaultBlocked.sendTo(p, new Object[0]);
        }
    }

    @EventHandler
    public void onDamage(EntityDamageByEntityEvent e) {
        if (!(e.getDamager() instanceof Player)) {
            return;
        }
        Player p = (Player)e.getDamager();
        if (this.batterys.contains(p.getUniqueId()) && p.getItemInHand() != null & this.isWeapon(p.getItemInHand().getType())) {
            e.setCancelled(true);
            this.batteryBlocked.sendTo(p, new Object[0]);
        }
    }

    private boolean isWeapon(Material mat) {
        return mat == Material.DIAMOND_SWORD || mat == Material.IRON_SWORD || mat == Material.GOLD_SWORD || mat == Material.WOOD_SWORD || mat == Material.STONE_SWORD || mat == Material.DIAMOND_AXE || mat == Material.IRON_AXE || mat == Material.GOLD_AXE || mat == Material.WOOD_AXE || mat == Material.STONE_AXE;
    }

    @EventHandler
    public void onDeath(GameDeathEvent e) {
        this.checkTeam(e.getDeath());
    }

    @EventHandler
    public void onKick(GameKickEvent e) {
        this.checkTeam(e.getPlayer());
    }

    private void checkTeam(UHCPlayer death) {
        UUID uuid = death.getUUID();
        if (this.assaults.contains(uuid)) {
            this.assaults.remove(uuid);
            this.clearTeam(death);
            return;
        }
        if (this.batterys.contains(uuid)) {
            this.batterys.remove(uuid);
            this.clearTeam(death);
            return;
        }
    }

    private void clearTeam(UHCPlayer death) {
        UHCTeam team = UHC.getTeam(death);
        if (team == null || team.getAlivePlayers().size() <= 0) {
            return;
        }
        team.getAlivePlayers().stream().filter(player -> player != null).forEach(player -> this.setJoker((UHCPlayer)player));
    }
}

