/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.events.player.rules;

import eu.scorpionltd.uhc.UHC;
import eu.scorpionltd.uhc.manager.langues.msg.MEnum;
import eu.scorpionltd.uhc.manager.players.UHCPlayer;
import eu.scorpionltd.uhc.manager.players.UHCPlayerManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerInteractEvent;

public class StealEvent
implements Listener {
    private static HashMap<UUID, List<Block>> placedBlocks = new HashMap();

    private static UUID isPlacedBlock(Block block) {
        for (UUID uuid : placedBlocks.keySet()) {
            if (!placedBlocks.get(uuid).contains(block)) continue;
            return uuid;
        }
        return null;
    }

    public static void addPlacedBlock(UUID uuid, Block block) {
        if (!placedBlocks.containsKey(uuid)) {
            placedBlocks.put(uuid, new ArrayList());
        }
        placedBlocks.get(uuid).add(block);
    }

    @EventHandler
    public void onPlace(BlockPlaceEvent event) {
        if (event.getPlayer() == null || event.getBlock() == null || event.getBlock().getType() == null || event.getBlock().getType() == Material.AIR) {
            return;
        }
        Player player = event.getPlayer();
        Block block = event.getBlock();
        if (!this.isSpecialBlocks(block.getType())) {
            return;
        }
        UHCPlayer uhcPlayer = UHCPlayerManager.getPlayer(player);
        if (uhcPlayer == null || !uhcPlayer.isPlaying()) {
            return;
        }
        StealEvent.addPlacedBlock(player.getUniqueId(), block);
    }

    @EventHandler
    public void onBreak(BlockBreakEvent event) {
        if (event.getPlayer() == null || event.getBlock() == null || event.getBlock().getType() == null || event.getBlock().getType() == Material.AIR) {
            return;
        }
        Player player = event.getPlayer();
        Block block = event.getBlock();
        if (!this.isSpecialBlocks(block.getType())) {
            return;
        }
        UUID uuid = StealEvent.isPlacedBlock(block);
        if (uuid == null) {
            return;
        }
        UHCPlayer uhcPlayer = UHCPlayerManager.getPlayer(player);
        if (uhcPlayer == null || !uhcPlayer.isPlaying()) {
            return;
        }
        if (uuid == uhcPlayer.getUUID() || UHC.getTeam(uuid) == UHC.getTeam(player)) {
            placedBlocks.get(uuid).remove(block);
            return;
        }
        event.setCancelled(true);
        MEnum.EVENTS_STEAL_CANT_BREAK.sendTo(player, new Object[0]);
    }

    @EventHandler
    public void onInteract(PlayerInteractEvent event) {
        if (event.getPlayer() == null || event.getAction() == null || event.getAction() != Action.RIGHT_CLICK_BLOCK || event.getClickedBlock() == null || event.getClickedBlock().getType() == null) {
            return;
        }
        Player player = event.getPlayer();
        Block block = event.getClickedBlock();
        if (!this.isInventoryBlocks(block.getType())) {
            return;
        }
        UUID uuid = StealEvent.isPlacedBlock(block);
        if (uuid == null || !this.isInventoryBlocks(block.getType())) {
            return;
        }
        UHCPlayer uhcPlayer = UHCPlayerManager.getPlayer(player);
        if (uhcPlayer == null || !uhcPlayer.isPlaying()) {
            return;
        }
        if (uuid == uhcPlayer.getUUID() || UHC.getTeam(uuid) == UHC.getTeam(player)) {
            return;
        }
        event.setCancelled(true);
        MEnum.EVENTS_STEAL_CANT_OPEN.sendTo(player, new Object[0]);
    }

    private boolean isSpecialBlocks(Material material) {
        return this.isInventoryBlocks(material) || material == Material.ENCHANTMENT_TABLE || material == Material.WORKBENCH || material == Material.ENDER_CHEST || material == Material.ANVIL;
    }

    private boolean isInventoryBlocks(Material material) {
        return material == Material.CHEST || material == Material.TRAPPED_CHEST || material == Material.FURNACE || material == Material.BURNING_FURNACE || material == Material.BREWING_STAND;
    }
}

