/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.events.player.move;

import com.google.common.collect.Sets;
import eu.scorpionltd.uhc.UHC;
import eu.scorpionltd.uhc.util.server.enums.Metadata;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerToggleFlightEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class JumpEvent
implements Listener {
    private Set<UUID> playersGround = Sets.newHashSet();
    private Map<UUID, Integer> cooldownJump = new HashMap<UUID, Integer>();

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        if (event.getPlayer() == null) {
            return;
        }
        final Player player = event.getPlayer();
        if (Metadata.NO_JUMP.has(player) && player.getVelocity().getY() > 0.0) {
            double jumpVelocity = 0.42f;
            if (player.hasPotionEffect(PotionEffectType.JUMP)) {
                int amplifier = 0;
                for (PotionEffect effect : player.getActivePotionEffects()) {
                    if (effect.getType() != PotionEffectType.JUMP) continue;
                    amplifier = effect.getAmplifier();
                    break;
                }
                jumpVelocity += (double)((float)(amplifier + 1) * 0.1f);
            }
            if (player.getLocation().getBlock().getType() != Material.LADDER && this.playersGround.contains(player.getUniqueId()) && !player.isOnGround() && Double.compare(player.getVelocity().getY(), jumpVelocity) == 0) {
                Location to = event.getTo();
                to.setY(event.getFrom().getY());
                event.setTo(to);
            }
            return;
        }
        if (player.isOnGround()) {
            this.playersGround.add(player.getUniqueId());
        } else {
            this.playersGround.remove(player.getUniqueId());
        }
        final UUID uuid = player.getUniqueId();
        if (player.getAllowFlight() || !Metadata.DOUBLE_JUMP.has(player) || this.cooldownJump.containsKey(uuid)) {
            return;
        }
        if (player.isOnGround()) {
            player.setAllowFlight(true);
            this.cooldownJump.put(uuid, 10);
            new BukkitRunnable(){

                public void run() {
                    int cooldown = (Integer)JumpEvent.this.cooldownJump.get(uuid);
                    if (cooldown == 0) {
                        this.cancel();
                        JumpEvent.this.cooldownJump.remove(uuid);
                        player.setAllowFlight(false);
                        player.setFlying(false);
                        return;
                    }
                    JumpEvent.this.cooldownJump.put(uuid, cooldown - 1);
                }
            }.runTaskTimer((Plugin)UHC.getInstance(), 20L, 20L);
        }
    }

    @EventHandler
    public void onPlayerToggleFlight(PlayerToggleFlightEvent event) {
        if (event.getPlayer() == null) {
            return;
        }
        Player player = event.getPlayer();
        UUID uuid = player.getUniqueId();
        if (player == null || !Metadata.DOUBLE_JUMP.has(player) || !this.cooldownJump.containsKey(uuid)) {
            return;
        }
        event.setCancelled(true);
        player.setAllowFlight(false);
        player.setFlying(false);
        player.setVelocity(player.getLocation().getDirection().multiply(1.6).setY(1.0));
        player.playSound(player.getLocation(), Sound.ENDERDRAGON_WINGS, 1.0f, 1.0f);
    }
}

