/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.events.player.food;

import eu.scorpionltd.uhc.UHC;
import eu.scorpionltd.uhc.events.custom.player.food.GoldenAppleEatEvent;
import eu.scorpionltd.uhc.manager.langues.msg.MEnum;
import eu.scorpionltd.uhc.manager.settings.values.Values;
import eu.scorpionltd.uhc.scoreboard.ScoreboardLife;
import eu.scorpionltd.uhc.util.player.EffectUtil;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffectType;

public class ConsumeEvent
implements Listener {
    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onItemConsume(PlayerItemConsumeEvent e) {
        if (e.getItem() == null) {
            return;
        }
        Player p = e.getPlayer();
        ItemStack item = e.getItem();
        if (item.getType() == Material.MILK_BUCKET && !Values.ITEM_MILK_BUCKET.getBoolean()) {
            e.setCancelled(true);
            p.getInventory().removeItem(new ItemStack[]{item});
            p.updateInventory();
            MEnum.EVENTS_NO_MILK.sendTo(p, new Object[0]);
            return;
        }
        if (item.getType() == Material.GOLDEN_APPLE) {
            if (item.getDurability() == 1 && !Values.CRAFT_GOLDEN_NOTCH.getBoolean()) {
                e.setCancelled(true);
                p.getInventory().removeItem(new ItemStack[]{item});
                p.updateInventory();
                MEnum.EVENTS_NO_GOLDEN_NOTCH.sendTo(p, new Object[0]);
                return;
            }
            if (item.getItemMeta() != null && item.getItemMeta().hasLore()) {
                Bukkit.getPluginManager().callEvent((Event)new GoldenAppleEatEvent(p, true));
            } else {
                Bukkit.getPluginManager().callEvent((Event)new GoldenAppleEatEvent(p, false));
            }
            int nerf_abso = Values.NERF_ABSORPTION.getInteger();
            if (nerf_abso != 2) {
                if (nerf_abso == 1) {
                    this.reduceAbso(p);
                } else {
                    this.removeAbso(p);
                }
            }
            ScoreboardLife.updateHealth(p);
        }
    }

    public void reduceAbso(final Player player) {
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)UHC.getInstance(), new Runnable(){

            @Override
            public void run() {
                EffectUtil.setAbsoHearths(player, 2);
            }
        }, 0L);
    }

    public void removeAbso(final Player player) {
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)UHC.getInstance(), new Runnable(){

            @Override
            public void run() {
                player.removePotionEffect(PotionEffectType.ABSORPTION);
            }
        }, 0L);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onEat(GoldenAppleEatEvent e) {
        if (e.isCancelled()) {
            return;
        }
        Player p = e.getPlayer();
        EffectUtil.giveEffect(p, PotionEffectType.ABSORPTION, 120, 1, true);
        if (e.isGoldenHead()) {
            EffectUtil.giveEffect(p, PotionEffectType.REGENERATION, 10, 2, true);
        } else {
            EffectUtil.giveEffect(p, PotionEffectType.REGENERATION, 5, 2, true);
        }
    }
}

