/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.events.player.death;

import eu.scorpionltd.uhc.events.custom.player.GameDeathEvent;
import eu.scorpionltd.uhc.events.custom.player.GameKillEvent;
import eu.scorpionltd.uhc.events.custom.player.GameRespawnEvent;
import eu.scorpionltd.uhc.manager.settings.values.Values;
import eu.scorpionltd.uhc.util.item.ItemUtil;
import eu.scorpionltd.uhc.util.player.InventoryUtil;
import eu.scorpionltd.uhc.util.server.PacketUtil;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.inventory.ItemStack;

public class TriggerDeathEvent
implements Listener {
    @EventHandler(priority=EventPriority.LOWEST)
    public void onTriggerDeathEvent(PlayerDeathEvent e) {
        List<ItemStack> noDrops;
        if (e.getEntity() == null || !(e.getEntity() instanceof Player)) {
            return;
        }
        Player player = e.getEntity();
        e.getDrops().addAll(Values.INVENTORY_DEATH.getListItemStack());
        if (Values.RULES_GOLDEN_APPLE.getBoolean()) {
            e.getDrops().add(new ItemStack(Material.GOLDEN_APPLE));
        }
        if (Values.RULES_GOLDEN_HEAD.getBoolean()) {
            e.getDrops().add(ItemUtil.getGoldenHead());
        }
        if (Values.RULES_HEAD.getBoolean()) {
            e.getDrops().add(ItemUtil.getHead(player.getName()));
        }
        if (!(noDrops = Values.INVENTORY_NO_DROP.getListItemStack()).isEmpty()) {
            for (Object raw : new ArrayList(e.getDrops())) {
                if (!(raw instanceof ItemStack)) continue;
                ItemStack drop = (ItemStack)raw;
                ItemStack copy = drop.clone();
                copy.setAmount(1);
                if (noDrops.contains(copy)) {
                    e.getDrops().remove(drop);
                    continue;
                }
                if (drop.getType() == Material.BANNER || drop.getType() == Material.FIREWORK) {
                    ItemStack compare = new ItemStack(drop.getType());
                    if (!noDrops.contains(compare)) continue;
                    e.getDrops().remove(drop);
                    continue;
                }
                if (!ItemUtil.isDamageable(copy.getType())) continue;
                copy.setDurability((short)0);
                if (!noDrops.contains(copy)) continue;
                e.getDrops().remove(drop);
            }
        }
        InventoryUtil.saveStuff(player);
        Bukkit.getPluginManager().callEvent((Event)new GameDeathEvent(player, e));
        PacketUtil.sendRespawn(player);
        Player killer = player.getKiller();
        if (killer != null) {
            Bukkit.getPluginManager().callEvent((Event)new GameKillEvent(player, killer, e));
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onTriggerRespawnEvent(PlayerRespawnEvent e) {
        if (e.getPlayer() == null) {
            return;
        }
        Bukkit.getPluginManager().callEvent((Event)new GameRespawnEvent(e.getPlayer(), e));
    }
}

