/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.events.player.death;

import eu.scorpionltd.uhc.UHC;
import eu.scorpionltd.uhc.events.custom.player.GameRespawnEvent;
import eu.scorpionltd.uhc.manager.players.UHCPlayer;
import eu.scorpionltd.uhc.manager.players.UHCPlayerManager;
import eu.scorpionltd.uhc.manager.settings.config.ConfigFile;
import eu.scorpionltd.uhc.manager.settings.values.Values;
import eu.scorpionltd.uhc.util.player.PlayerUtil;
import eu.scorpionltd.uhc.util.server.enums.Status;
import eu.scorpionltd.uhc.util.world.monde.LobbyUtil;
import eu.scorpionltd.utils.task.Cooldown;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class RespawnEvent
implements Listener {
    @EventHandler(priority=EventPriority.HIGHEST)
    public void onRespawnEvent(final GameRespawnEvent e) {
        if (e.isCancelled()) {
            return;
        }
        final Player player = e.getDeath().getPlayer();
        final PlayerRespawnEvent event = e.getRespawnEvent();
        if (!Status.getCurrentStatus().isStart()) {
            event.setRespawnLocation(LobbyUtil.getLobbyLocation());
            return;
        }
        new BukkitRunnable(){

            public void run() {
                player.setPlayerListName(ConfigFile.TAB_DEAD_PREFIX.getString() + e.getDeath().getName());
                if (Values.RULES_SPECTATOR.getBoolean()) {
                    event.setRespawnLocation(e.getDeath().getInventory().getLocation());
                    player.setGameMode(GameMode.SPECTATOR);
                    return;
                }
                event.setRespawnLocation(LobbyUtil.getLobbyLocation());
                player.setGameMode(GameMode.ADVENTURE);
                if (Values.RULES_KICK_DEATH.getBoolean()) {
                    int cooldownBeforeKick = 15;
                    new Cooldown(cooldownBeforeKick){
                        private UHCPlayer death;
                        {
                            this.death = e.getDeath();
                        }

                        public void onFinish() {
                            if (this.death.isPlaying()) {
                                return;
                            }
                            PlayerUtil.removeWhitelist((CommandSender)UHCPlayerManager.getActualHost().getPlayer(), Bukkit.getOfflinePlayer((UUID)this.death.getUUID()));
                            if (this.death.getPlayer() != null) {
                                this.death.getPlayer().kickPlayer(ChatColor.RED + "Merci d'avoir jou\u00e9");
                            }
                        }
                    };
                }
            }
        }.runTaskLater((Plugin)UHC.getInstance(), 10L);
    }
}

