/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.events.player.death;

import eu.scorpionltd.uhc.UHC;
import eu.scorpionltd.uhc.events.custom.player.GameDeathEvent;
import eu.scorpionltd.uhc.manager.langues.LangueManager;
import eu.scorpionltd.uhc.manager.langues.msg.MEnum;
import eu.scorpionltd.uhc.manager.players.UHCPlayer;
import eu.scorpionltd.uhc.manager.players.UHCPlayerManager;
import eu.scorpionltd.uhc.manager.settings.config.ConfigFile;
import eu.scorpionltd.uhc.manager.settings.values.Values;
import eu.scorpionltd.uhc.tasks.TimerManager;
import eu.scorpionltd.uhc.util.chat.ChatUtil;
import eu.scorpionltd.uhc.util.chat.DeathCause;
import eu.scorpionltd.uhc.util.player.PlayerUtil;
import eu.scorpionltd.uhc.util.server.ServerUtil;
import eu.scorpionltd.uhc.util.server.enums.Status;
import eu.scorpionltd.utils.task.Cooldown;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.PlayerDeathEvent;

public class DeathEvent
implements Listener {
    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerDeath(GameDeathEvent e) {
        final UHCPlayer death = e.getDeath();
        PlayerDeathEvent event = e.getDeathEvent();
        if (!Status.getCurrentStatus().isStart()) {
            event.setDeathMessage("");
            event.setKeepInventory(true);
            event.setKeepLevel(true);
            event.setDroppedExp(0);
            return;
        }
        Player killer = e.getDeathEvent().getEntity().getKiller();
        String log = "DEATH PLAYER: " + death.getName();
        if (killer != null) {
            log = log + " killed by " + killer.getName();
        } else if (death.getPlayer().getLastDamageCause() != null) {
            log = log + death.getPlayer().getLastDamageCause().getCause().name();
        }
        System.out.println(log);
        if (death.getPlayer().getLastDamageCause() != null) {
            EntityDamageEvent.DamageCause cause = death.getPlayer().getLastDamageCause().getCause();
            if (ConfigFile.INGAME_CUSTOM_DEATH_MESSAGE.getBoolean() && !event.getDeathMessage().equals("")) {
                event.setDeathMessage("");
                String killerName = "Monstre";
                if (killer != null) {
                    killerName = UHCPlayerManager.getPlayer(killer).getTeamPrefix() + killer.getName();
                }
                DeathCause.getDeathCauseMessage(cause).sendAll(death.getTeamPrefix() + death.getName(), killerName);
            }
            if (ConfigFile.ALERTS_DEATH_CAUSE.getBoolean()) {
                ChatUtil.sendAlert(ChatUtil.getDeathAlert("Mort " + death.getPlayer().getName(), DeathCause.getDeathCauseName(cause).getText(LangueManager.getDefaultLangue(), death.getPlayer().getKiller() != null ? death.getPlayer().getKiller().getName() : "Monstre"), death.getInventory().getLocation()));
            }
        }
        if (e.isCancelled()) {
            return;
        }
        death.setDead(true);
        PlayerUtil.giveDeathSpecs(e);
        int reviveAuto = Values.RULES_REVIVE_AUTO.getInteger();
        if (reviveAuto != 0) {
            boolean beforeFH = reviveAuto == 1 && TimerManager.hasTimerFinalHeal();
            boolean beforePVP = reviveAuto == 2 && TimerManager.hasTimerPVP();
            boolean bl = beforePVP;
            if (beforeFH || beforePVP) {
                new Cooldown(1){

                    public void onFinish() {
                        MEnum.REVIVE_AUTO.sendAll(death.getName());
                        new Cooldown(2){

                            public void onFinish() {
                                Player newPlayer = Bukkit.getPlayer((UUID)death.getUUID());
                                if (newPlayer != null && newPlayer.isOnline()) {
                                    PlayerUtil.revivePlayer(newPlayer);
                                }
                            }
                        };
                    }
                };
            }
            return;
        }
        if (Values.SERVER_FINISH_AUTO.getBoolean() && !Status.getCurrentStatus().isFinish()) {
            boolean isWin = this.checkWinning();
            if (!isWin) {
                return;
            }
            ServerUtil.sendWinRequest();
        }
    }

    private boolean checkWinning() {
        boolean result = false;
        if (Values.TEAM_FFA.getBoolean() && UHCPlayerManager.getPlayingsPlayer().size() == 1) {
            result = true;
        }
        if (!Values.TEAM_FFA.getBoolean() && UHC.getConnectedTeams().size() == 1) {
            result = true;
        }
        return result;
    }
}

