/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.events.player.connexion;

import eu.scorpionltd.listeners.custom.ScorpionQuitEvent;
import eu.scorpionltd.uhc.UHC;
import eu.scorpionltd.uhc.events.custom.player.connexion.GameKickEvent;
import eu.scorpionltd.uhc.events.custom.player.connexion.GameQuitEvent;
import eu.scorpionltd.uhc.events.item.inventory.CreativeEvent;
import eu.scorpionltd.uhc.manager.langues.msg.MEnum;
import eu.scorpionltd.uhc.manager.players.UHCPlayer;
import eu.scorpionltd.uhc.manager.players.UHCPlayerManager;
import eu.scorpionltd.uhc.manager.settings.database.DatabaseManager;
import eu.scorpionltd.uhc.manager.settings.values.Values;
import eu.scorpionltd.uhc.manager.teams.UHCTeam;
import eu.scorpionltd.uhc.util.player.InventoryUtil;
import eu.scorpionltd.uhc.util.server.PacketUtil;
import eu.scorpionltd.uhc.util.server.enums.Metadata;
import eu.scorpionltd.uhc.util.server.enums.Status;
import eu.scorpionltd.utils.player.ScorpionPlayer;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.fusesource.jansi.Ansi;

public class QuitEvent
implements Listener {
    @EventHandler(priority=EventPriority.HIGHEST)
    public void onQuit(ScorpionQuitEvent e) {
        Status status;
        UHCTeam team;
        ScorpionPlayer p = e.getScorpionPlayer();
        UHCPlayer up = UHCPlayerManager.getPlayer(p);
        DatabaseManager.getDatabase().onPlayerQuit(p.getUUID());
        UHC.getScoreboard().leave(p);
        e.getEventPlayerQuitEvent().setQuitMessage("");
        if (Metadata.INVISIBLE_ARMOR.has(p.getPlayer())) {
            PacketUtil.showArmor(p.getPlayer());
        }
        if ((team = UHC.getTeam(up)) != null) {
            team.resetDisplay(up);
        }
        if (!(status = Status.getCurrentStatus()).isStart()) {
            this.leaveLobby(up);
        } else {
            this.leaveGame(up);
        }
    }

    private void leaveLobby(UHCPlayer up) {
        up.setPlaying(false);
        CreativeEvent.removeMode(up.getUUID());
        if (up.isBypassMode()) {
            up.giveBypassMode();
        }
        MEnum.LEAVE_MESSAGE.sendAll(up.getName());
    }

    private void leaveGame(UHCPlayer up) {
        if (up.isHost() || up.isSpec() || !up.isPlaying()) {
            return;
        }
        Player p = up.getPlayer();
        up.setDeconnecting(true);
        InventoryUtil.saveStuff(p);
        Bukkit.getPluginManager().callEvent((Event)new GameQuitEvent(up));
        MEnum.LEAVE_GAME_MESSAGE.sendAll(up.getName());
        if (Values.SERVER_DECONNEXION_TYPE.getInteger() == 0) {
            return;
        }
        this.startDeconnexionTask(up);
    }

    private void startDeconnexionTask(final UHCPlayer up) {
        final int maxDeconnexionTime = Values.SERVER_DECONNEXION_TIME.getInteger();
        new BukkitRunnable(){

            public void run() {
                int deconnexionTime = up.getInfos().getDeconnexionTime();
                if (!up.isDeconnecting() || !up.isPlaying()) {
                    this.cancel();
                    return;
                }
                if (deconnexionTime >= maxDeconnexionTime) {
                    OfflinePlayer offline = Bukkit.getOfflinePlayer((UUID)up.getUUID());
                    System.out.println(Ansi.ansi().fg(Ansi.Color.RED).boldOff().toString() + "WHITELIST: REMOVE " + up.getName() + Ansi.ansi().fg(Ansi.Color.WHITE).boldOff().toString());
                    offline.setWhitelisted(false);
                    up.setDead(true);
                    up.setDeconnecting(false);
                    Bukkit.getPluginManager().callEvent((Event)new GameKickEvent(up));
                    this.cancel();
                    return;
                }
                up.getInfos().addDeconnexionTime();
            }
        }.runTaskTimer((Plugin)UHC.getInstance(), 20L, 20L);
    }
}

