/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.events.player.connexion;

import eu.scorpionltd.listeners.custom.ScorpionJoinEvent;
import eu.scorpionltd.uhc.UHC;
import eu.scorpionltd.uhc.events.custom.player.connexion.GameJoinEvent;
import eu.scorpionltd.uhc.manager.game.holograms.HologramManager;
import eu.scorpionltd.uhc.manager.langues.msg.MEnum;
import eu.scorpionltd.uhc.manager.players.UHCPlayer;
import eu.scorpionltd.uhc.manager.players.UHCPlayerManager;
import eu.scorpionltd.uhc.manager.settings.config.ConfigFile;
import eu.scorpionltd.uhc.manager.settings.values.Values;
import eu.scorpionltd.uhc.manager.teams.UHCTeam;
import eu.scorpionltd.uhc.scoreboard.TabManager;
import eu.scorpionltd.uhc.tasks.TimerManager;
import eu.scorpionltd.uhc.util.player.EffectUtil;
import eu.scorpionltd.uhc.util.player.InventoryUtil;
import eu.scorpionltd.uhc.util.player.PlayerUtil;
import eu.scorpionltd.uhc.util.server.PacketUtil;
import eu.scorpionltd.uhc.util.server.enums.Metadata;
import eu.scorpionltd.uhc.util.server.enums.Status;
import eu.scorpionltd.uhc.util.world.monde.LobbyUtil;
import eu.scorpionltd.utils.player.ScorpionPlayer;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class JoinEvent
implements Listener {
    private boolean firstConnection = true;

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onJoin(ScorpionJoinEvent e) {
        Status status;
        ScorpionPlayer p = e.getScorpionPlayer();
        UHCPlayer up = UHCPlayerManager.havePlayer(p) ? UHCPlayerManager.getPlayer(p) : new UHCPlayer(p);
        UHC.getScoreboard().join(p);
        TabManager.send(p.getPlayer());
        e.getEventPlayerJoinEvent().setJoinMessage("");
        if (Metadata.INVISIBLE_ARMOR.has(p.getPlayer())) {
            PacketUtil.hideArmor(p.getPlayer());
        }
        if (!(status = Status.getCurrentStatus()).isStart()) {
            this.joinLobby(up);
        } else {
            this.joinGame(up);
        }
    }

    private void joinLobby(UHCPlayer up) {
        final Player player = up.getPlayer();
        new BukkitRunnable(){

            public void run() {
                player.teleport(LobbyUtil.getLobbyLocation());
                new BukkitRunnable(){

                    public void run() {
                        if (JoinEvent.this.firstConnection) {
                            JoinEvent.this.firstConnection = false;
                            HologramManager.refreshHolograms();
                        }
                    }
                }.runTaskLater((Plugin)UHC.getInstance(), 5L);
            }
        }.runTaskLater((Plugin)UHC.getInstance(), 5L);
        player.setGameMode(GameMode.ADVENTURE);
        player.setMaxHealth(20.0);
        player.setHealth(20.0);
        player.setFoodLevel(20);
        player.setLevel(0);
        player.setExp(0.0f);
        player.setWalkSpeed(0.2f);
        EffectUtil.resetEffect(player);
        ItemStack air = new ItemStack(Material.AIR);
        player.getInventory().setArmorContents(new ItemStack[]{air, air, air, air});
        player.getInventory().clear();
        InventoryUtil.giveJoinItems(up);
        String name = up.getName();
        if (!Status.getCurrentStatus().isStart()) {
            name = up.getRankName();
        }
        if (up.isHost()) {
            player.setPlayerListName(ConfigFile.TEXT_PLAYER_HOST.getString() + name);
            up.setHost(true);
        } else if (up.isSpec()) {
            player.setPlayerListName(ConfigFile.TEXT_SPEC_HOST.getString() + name);
            up.setSpec(true);
        } else {
            up.setPlaying(true);
        }
        UHCTeam team = UHC.getTeam(up);
        if (team != null) {
            team.sendDisplay(up);
        }
        MEnum.JOIN_MESSAGE.sendAll(up.getName());
    }

    private void joinGame(UHCPlayer up) {
        final Player player = up.getPlayer();
        String name = up.getName();
        if (up.isHost()) {
            player.setPlayerListName(ConfigFile.TEXT_PLAYER_HOST.getString() + name);
            up.setHost(true);
            return;
        }
        if (up.isSpec()) {
            player.setPlayerListName(ConfigFile.TEXT_SPEC_HOST.getString() + name);
            up.setSpec(true);
            return;
        }
        if (Values.RULES_LATESCATTER.getBoolean() && TimerManager.hasTimerPVP() && !up.isDead() && !up.isDeconnecting() && !up.isPlaying()) {
            PlayerUtil.latescatterPlayer(player);
            MEnum.EVENTS_LATE_SCATTER.sendAll(up.getName());
            return;
        }
        if (!up.isPlaying() || !up.isDeconnecting()) {
            new BukkitRunnable(){

                public void run() {
                    player.teleport(LobbyUtil.getLobbyLocation());
                }
            }.runTaskLater((Plugin)UHC.getInstance(), 5L);
            return;
        }
        player.setDisplayName(Values.CHAT_SEE_GAME_RANKS.getBoolean() ? player.getDisplayName() : up.getName());
        player.setPlayerListName(name);
        PacketUtil.changeCoords(player);
        up.setPlaying(true);
        up.setDeconnecting(false);
        UHCTeam team = UHC.getTeam(up);
        if (team != null) {
            team.sendDisplay(up);
        }
        Bukkit.getPluginManager().callEvent((Event)new GameJoinEvent(up));
        int deconnexionType = Values.SERVER_DECONNEXION_TYPE.getInteger();
        if (deconnexionType == 0) {
            MEnum.RECONNEXION_MESSAGE.sendAll(up.getName());
            return;
        }
        MEnum.RECONNEXION_TIME_MESSAGE.sendAll(up.getName(), up.getInfos().getDeconnexionTime());
        if (deconnexionType == 1) {
            up.getInfos().setDeconnexionTime(0);
        }
    }
}

