/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.events.item.potions;

import eu.scorpionltd.uhc.manager.settings.values.Values;
import eu.scorpionltd.uhc.util.item.ItemUtil;
import java.util.Random;
import org.bukkit.Material;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerItemDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffectType;

public class NerfEvent
implements Listener {
    private final Material[] armors = new Material[]{Material.GOLD_HELMET, Material.GOLD_CHESTPLATE, Material.GOLD_LEGGINGS, Material.GOLD_BOOTS, Material.LEATHER_HELMET, Material.LEATHER_CHESTPLATE, Material.LEATHER_LEGGINGS, Material.LEATHER_BOOTS, Material.CHAINMAIL_HELMET, Material.CHAINMAIL_CHESTPLATE, Material.CHAINMAIL_LEGGINGS, Material.CHAINMAIL_BOOTS, Material.DIAMOND_HELMET, Material.DIAMOND_CHESTPLATE, Material.DIAMOND_LEGGINGS, Material.DIAMOND_BOOTS};

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGH)
    public void onNerfStrength(EntityDamageByEntityEvent e) {
        if (e.getDamager() == null || !(e.getDamager() instanceof Player) || e.getEntity() == null || !(e.getEntity() instanceof LivingEntity)) {
            return;
        }
        Player damager = (Player)e.getDamager();
        boolean hasStrength = damager.hasPotionEffect(PotionEffectType.INCREASE_DAMAGE);
        boolean isCritical = e.getDamage() > 0.0 ? ItemUtil.isCriticalDamage(damager) : false;
        boolean bl = isCritical;
        if (!hasStrength && !isCritical) {
            return;
        }
        int nerfStrength = Values.NERF_STRENGTH.getInteger();
        int nerfCritic = Values.NERF_CRITIC.getInteger();
        if (nerfStrength == 100 && nerfCritic == 100) {
            return;
        }
        double percentStrength = 1.0 * (double)nerfStrength / 100.0;
        double percentCritic = 1.0 * (double)nerfCritic / 100.0;
        double levelStrength = ItemUtil.getEnchantEffect(damager);
        double itemDamage = ItemUtil.getAttackDamageItem(damager.getItemInHand());
        double enchantDamage = ItemUtil.getEnchantDamageItem(damager.getItemInHand());
        double strengthDamage = hasStrength ? 1.0 + 1.3 * levelStrength * percentStrength : 1.0;
        double criticDamage = isCritical ? 1.0 + 0.5 * percentCritic : 1.0;
        double vanillaOnlyCritic = itemDamage * (1.0 + 1.3 * levelStrength) * 0.5;
        int coeffOnlyCritic = (int)Math.round(vanillaOnlyCritic / e.getDamage());
        if (isCritical && coeffOnlyCritic == 1) {
            double total = itemDamage * strengthDamage * (0.5 * percentCritic);
            double damagePercent = total / e.getDamage();
            this.changeDamageEvent(e, total, damagePercent);
            return;
        }
        double total = itemDamage * strengthDamage * criticDamage + enchantDamage;
        double damagePercent = total / e.getDamage();
        this.changeDamageEvent(e, total, damagePercent);
    }

    private void changeDamageEvent(EntityDamageByEntityEvent event, double total, double coeff) {
        event.setDamage(total);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGH)
    public void onNerfStrength(PlayerItemDamageEvent e) {
        if (e.getPlayer() == null || e.getItem() == null) {
            return;
        }
        if (!e.getPlayer().hasPotionEffect(PotionEffectType.INCREASE_DAMAGE) || Values.NERF_STRENGTH.getInteger() >= 100) {
            return;
        }
        ItemStack item = e.getItem();
        Material[] arrmaterial = this.armors;
        int n = arrmaterial.length;
        for (int n2 = 0; n2 < n; ++n2) {
            int random = new Random().nextInt(2);
            Material material = arrmaterial[n2];
            if (item.getType() != material || random == 0) continue;
            e.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onNerfResistance(EntityDamageEvent e) {
        if (e.getEntity() == null || !(e.getEntity() instanceof Player)) {
            return;
        }
        Player p = (Player)e.getEntity();
        if (!p.hasPotionEffect(PotionEffectType.DAMAGE_RESISTANCE)) {
            return;
        }
        double percent = 1.0 * (double)Values.NERF_RESISTANCE.getInteger() / 100.0;
        e.setDamage(EntityDamageEvent.DamageModifier.RESISTANCE, e.getDamage(EntityDamageEvent.DamageModifier.RESISTANCE) * percent);
    }
}

