/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.events.item.inventory;

import eu.scorpionltd.uhc.manager.langues.msg.MEnum;
import eu.scorpionltd.uhc.manager.players.UHCPlayerManager;
import eu.scorpionltd.uhc.manager.settings.values.Values;
import eu.scorpionltd.utils.item.armor.ArmorEquipEvent;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;

public class ArmorEvent
implements Listener {
    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onArmorEquipEvent(ArmorEquipEvent e) {
        Player p = e.getPlayer();
        int playerDiamondArmorLimit = UHCPlayerManager.getPlayer(p).getModifiers().getDiamondArmorLimit();
        if (playerDiamondArmorLimit > -1) {
            if (this.countDiamondArmor(p) >= playerDiamondArmorLimit && !this.isDiamondArmor(e.getOldArmorPiece()) && this.isDiamondArmor(e.getNewArmorPiece())) {
                e.setCancelled(true);
                MEnum.EVENTS_ARMOR_LIMIT.sendTo(p, playerDiamondArmorLimit);
            }
            return;
        }
        int diamondArmorMax = Values.ITEM_ARMOR_LIMIT.getInteger();
        if (this.countDiamondArmor(p) >= diamondArmorMax && !this.isDiamondArmor(e.getOldArmorPiece()) && this.isDiamondArmor(e.getNewArmorPiece())) {
            e.setCancelled(true);
            MEnum.EVENTS_ARMOR_LIMIT.sendTo(p, diamondArmorMax);
        }
    }

    public boolean isDiamondArmor(ItemStack stack) {
        if (stack == null || stack.getType() == null) {
            return false;
        }
        return stack.getType() == Material.DIAMOND_HELMET || stack.getType() == Material.DIAMOND_CHESTPLATE || stack.getType() == Material.DIAMOND_LEGGINGS || stack.getType() == Material.DIAMOND_BOOTS;
    }

    public int countDiamondArmor(Player p) {
        int diamondArmor = 0;
        for (ItemStack stack : p.getInventory().getArmorContents()) {
            if (stack == null || stack.getType() == null || stack.getType() != Material.DIAMOND_HELMET && stack.getType() != Material.DIAMOND_CHESTPLATE && stack.getType() != Material.DIAMOND_LEGGINGS && stack.getType() != Material.DIAMOND_BOOTS) continue;
            ++diamondArmor;
        }
        return diamondArmor;
    }
}

