/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.events.item;

import eu.scorpionltd.uhc.events.custom.item.GameInteractEvent;
import eu.scorpionltd.uhc.manager.langues.msg.MEnum;
import eu.scorpionltd.uhc.manager.players.UHCPlayer;
import eu.scorpionltd.uhc.manager.settings.SettingsManager;
import eu.scorpionltd.uhc.manager.settings.config.ConfigFile;
import eu.scorpionltd.uhc.manager.settings.values.ValueCategorie;
import eu.scorpionltd.uhc.manager.settings.values.Values;
import eu.scorpionltd.uhc.tasks.TimerManager;
import eu.scorpionltd.uhc.ui.MenuPrincipal;
import eu.scorpionltd.uhc.ui.player.MenuChooseTeams;
import eu.scorpionltd.uhc.ui.player.profile.MenuPlayer;
import eu.scorpionltd.uhc.util.player.InventoryUtil;
import eu.scorpionltd.uhc.util.player.PlayerUtil;
import eu.scorpionltd.uhc.util.server.enums.Status;
import eu.scorpionltd.uhc.util.ui.ConfirmAction;
import eu.scorpionltd.uhc.util.world.WorldUtil;
import eu.scorpionltd.uhc.util.world.monde.LobbyUtil;
import eu.scorpionltd.utils.player.ScorpionPlayer;
import java.util.LinkedHashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;

public class InteractEvent
implements Listener {
    @EventHandler
    public void onInteract(PlayerInteractEntityEvent e) {
        if (e.getPlayer() == null || e.getRightClicked() == null || !(e.getRightClicked() instanceof ArmorStand) || e.getPlayer().getWorld() == null || e.getPlayer().getWorld() != LobbyUtil.getLobbyWorld()) {
            return;
        }
        e.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onEventInteract(PlayerInteractEvent e) {
        if (e.getItem() == null || e.getItem().getType() == null || e.getItem().getType() == Material.AIR || e.getAction() == null || e.getPlayer() == null) {
            return;
        }
        Bukkit.getPluginManager().callEvent((Event)new GameInteractEvent(e.getPlayer(), e));
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onGameInteract(GameInteractEvent e) {
        if (e.isCancelled()) {
            return;
        }
        if (!Status.getCurrentStatus().isStart()) {
            Material material = e.getItem().getType();
            short data = e.getItem().getDurability();
            final UHCPlayer up = e.getUHCPlayer();
            ScorpionPlayer sp = up.getScorpionPlayer();
            if (!up.isBypassMode()) {
                e.setCancelled(true);
                if (material == Material.BANNER && ConfigFile.ITEMS_TEAMS.isSameMaterial(material) || ConfigFile.ITEMS_TEAMS.isSameMaterialData(material, data)) {
                    if (Status.getCurrentStatus() != Status.WAITING) {
                        return;
                    }
                    new MenuChooseTeams(sp).openMenu();
                    return;
                }
                if (ConfigFile.ITEMS_CONFIG.isSameMaterialData(material, data)) {
                    if (Status.getCurrentStatus() != Status.WAITING) {
                        return;
                    }
                    new MenuPrincipal(sp).openMenu();
                    return;
                }
                if (ConfigFile.ITEMS_PROFILE.isSameMaterialData(material, data)) {
                    new MenuPlayer(sp).openMenu();
                    return;
                }
                if (ConfigFile.ITEMS_HUB.isSameMaterialData(material, data)) {
                    if (ConfigFile.ITEMS_CONFIRM_TO_LEAVE.getBoolean()) {
                        new ConfirmAction(sp, 5){

                            @Override
                            public void onStart() {
                                MEnum.CONFIRM_TO_LEAVE.send(up, new Object[0]);
                            }

                            @Override
                            public void onConfirm() {
                                MEnum.CONFIRM_LEAVE_SUCCESS.send(up, new Object[0]);
                                PlayerUtil.returnHub(up);
                            }

                            @Override
                            public void onCancel() {
                                MEnum.CONFIRM_LEAVE_CANCEL.send(up, new Object[0]);
                            }
                        };
                        return;
                    }
                    PlayerUtil.returnHub(up);
                    return;
                }
            }
            return;
        }
        if (e.getAction() == Action.RIGHT_CLICK_BLOCK && e.getInteractEvent().getClickedBlock() != null) {
            this.checkWorldLimits(e);
        }
        if (Values.ITEM_BOTTLE_STACK.getInteger() != 0 && e.getInteractEvent().useItemInHand() == Event.Result.ALLOW && (e.getItem().getType() == Material.GLASS_BOTTLE || e.getItem().getType() == Material.POTION)) {
            this.stackPotions(e.getInteractEvent().getPlayer());
        }
    }

    private void checkWorldLimits(GameInteractEvent e) {
        ItemStack stack = e.getItem();
        Block b = e.getInteractEvent().getClickedBlock();
        Player player = e.getUHCPlayer().getPlayer();
        if (b.getType() != Material.OBSIDIAN && this.cantUse(player, stack, Material.FLINT_AND_STEEL)) {
            this.blockUse(player, e);
            return;
        }
        if (this.cantUse(player, stack, Material.BED)) {
            this.blockUse(player, e);
            return;
        }
        if (this.cantUse(player, stack, Material.LAVA_BUCKET)) {
            if (PlayerUtil.getNearEnnemies(15.0, player).isEmpty()) {
                return;
            }
            this.blockUse(player, e);
            return;
        }
    }

    private void blockUse(Player player, GameInteractEvent e) {
        e.setCancelled(true);
        e.getInteractEvent().setUseInteractedBlock(Event.Result.DENY);
        MEnum.EVENTS_BLOCK_INTERACT.sendTo(player, new Object[0]);
        player.updateInventory();
    }

    private boolean cantUse(Player player, ItemStack stack, Material material) {
        World.Environment env = WorldUtil.getEnv(player.getWorld());
        ValueCategorie cat = env.equals((Object)World.Environment.NORMAL) ? ValueCategorie.OVERWORLD : (env.equals((Object)World.Environment.NETHER) ? ValueCategorie.NETHER : ValueCategorie.END);
        boolean value = (Boolean)SettingsManager.getSettings(cat, material).getValue();
        boolean isIPVP = TimerManager.hasTimerPVP() && !PlayerUtil.getNearEnnemies(5.0, player).isEmpty();
        return stack.getType() == material && (!value || isIPVP);
    }

    private void stackPotions(Player player) {
        int numberValue = (int)Math.pow(2.0, 1 + Values.ITEM_BOTTLE_STACK.getInteger());
        LinkedHashMap<ItemStack, Integer> potionMap = new LinkedHashMap<ItemStack, Integer>();
        for (int i = 0; i < player.getInventory().getSize(); ++i) {
            ItemStack item = player.getInventory().getItem(i);
            if (item == null || item.getType() == null || item.getType() != Material.POTION) continue;
            ItemStack copy = item.clone();
            copy.setAmount(1);
            if (potionMap.containsKey(copy)) {
                potionMap.put(copy, (Integer)potionMap.get(item) + item.getAmount());
            } else {
                potionMap.put(copy, item.getAmount());
            }
            player.getInventory().clear(i);
        }
        for (Map.Entry entry : potionMap.entrySet()) {
            ItemStack stack = (ItemStack)entry.getKey();
            int amount = 0;
            for (int i = 0; i < (Integer)entry.getValue(); ++i) {
                if (amount == numberValue) {
                    stack.setAmount(numberValue);
                    InventoryUtil.addItem(player, stack.clone());
                    amount = 0;
                }
                ++amount;
            }
            if (amount <= 0) continue;
            stack.setAmount(amount);
            InventoryUtil.addItem(player, stack.clone());
        }
        player.updateInventory();
    }
}

