/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.events.item;

import eu.scorpionltd.uhc.manager.langues.msg.MEnum;
import eu.scorpionltd.uhc.manager.players.UHCPlayer;
import eu.scorpionltd.uhc.manager.players.UHCPlayerManager;
import eu.scorpionltd.uhc.manager.players.infos.PlayerModifiers;
import eu.scorpionltd.uhc.manager.settings.values.Values;
import eu.scorpionltd.uhc.util.item.EnchantItem;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.enchantment.EnchantItemEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.inventory.AnvilInventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;

public class EnchantEvent
implements Listener {
    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void enchantEvent(EnchantItemEvent e) {
        if (e.getEnchanter() == null || e.getItem() == null || !Values.LIMIT_ENCHANT.getBoolean()) {
            return;
        }
        UHCPlayer player = UHCPlayerManager.getPlayer(e.getEnchanter());
        if (this.containsBlockedEnchant(player, e.getEnchantsToAdd(), e.getItem().getType())) {
            e.setCancelled(true);
            MEnum.EVENTS_NO_ENCHANT.sendTo(e.getEnchanter(), new Object[0]);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onAnvil(InventoryClickEvent e) {
        if (!(e.getWhoClicked() != null && e.getWhoClicked() instanceof Player && Values.LIMIT_ANVIL.getBoolean() && e.getClickedInventory() != null && e.getClickedInventory() instanceof AnvilInventory)) {
            return;
        }
        Player p = (Player)e.getWhoClicked();
        AnvilInventory anvil = (AnvilInventory)e.getClickedInventory();
        InventoryView view = e.getView();
        int rawSlot = e.getRawSlot();
        if (rawSlot == view.convertSlot(rawSlot) && rawSlot == 2) {
            ItemStack result = anvil.getItem(2);
            if (result == null || result.getEnchantments() == null) {
                return;
            }
            UHCPlayer player = UHCPlayerManager.getPlayer(p);
            if (this.containsBlockedEnchant(player, result.getEnchantments(), result.getType())) {
                this.getBlockedEnchant(player, result.getEnchantments(), result.getType()).keySet().forEach(enchant -> result.removeEnchantment(enchant));
                MEnum.EVENTS_NO_ENCHANT.sendTo(p, new Object[0]);
            }
            return;
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onPickUp(PlayerPickupItemEvent e) {
        if (e.getPlayer() == null || e.getItem() == null || e.getItem().getItemStack() == null || e.getItem().getItemStack().getEnchantments() == null || !Values.LIMIT_ANVIL.getBoolean() || !Values.LIMIT_ENCHANT.getBoolean()) {
            return;
        }
        ItemStack item = e.getItem().getItemStack();
        UHCPlayer player = UHCPlayerManager.getPlayer(e.getPlayer());
        if (this.containsBlockedEnchant(player, item.getEnchantments(), item.getType())) {
            e.setCancelled(true);
            e.getItem().remove();
        }
    }

    private boolean containsBlockedEnchant(UHCPlayer player, Map<Enchantment, Integer> enchantments, Material material) {
        return enchantments.entrySet().stream().anyMatch(x -> this.isBlockedEnchant(player, (Enchantment)x.getKey(), (Integer)x.getValue(), material));
    }

    private Map<Enchantment, Integer> getBlockedEnchant(UHCPlayer player, Map<Enchantment, Integer> enchantments, Material material) {
        return enchantments.entrySet().stream().filter(x -> this.isBlockedEnchant(player, (Enchantment)x.getKey(), (Integer)x.getValue(), material)).collect(Collectors.toMap(x -> (Enchantment)x.getKey(), x -> (Integer)x.getValue()));
    }

    private boolean isBlockedEnchant(UHCPlayer player, Enchantment enchant, int value, Material mat) {
        EnchantItem ench = EnchantItem.getEnchant(enchant);
        PlayerModifiers modifier = player.getModifiers();
        if (modifier.getProtectionDiamond() > -1 && enchant.equals((Object)Enchantment.PROTECTION_ENVIRONMENTAL) && this.isDiamondMaterial(mat)) {
            return modifier.getProtectionDiamond() < value;
        }
        if (modifier.getProtectionIron() > -1 && enchant.equals((Object)Enchantment.PROTECTION_ENVIRONMENTAL) && this.isIronMaterial(mat)) {
            return modifier.getProtectionIron() < value;
        }
        if (modifier.getSharpnessDiamond() > -1 && enchant.equals((Object)Enchantment.DAMAGE_ALL) && this.isDiamondMaterial(mat)) {
            return modifier.getSharpnessDiamond() < value;
        }
        if (modifier.getSharpnessIron() > -1 && enchant.equals((Object)Enchantment.DAMAGE_ALL) && this.isIronMaterial(mat)) {
            return modifier.getSharpnessIron() < value;
        }
        if (ench.getGlobalValue() < value) {
            return true;
        }
        if (this.isDiamondMaterial(mat) && ench.getDiamondValue() < value) {
            return true;
        }
        return this.isIronMaterial(mat) && ench.getIronValue() < value;
    }

    private boolean isDiamondMaterial(Material mat) {
        return mat == Material.DIAMOND_AXE || mat == Material.DIAMOND_BOOTS || mat == Material.DIAMOND_CHESTPLATE || mat == Material.DIAMOND_HELMET || mat == Material.DIAMOND_HOE || mat == Material.DIAMOND_LEGGINGS || mat == Material.DIAMOND_PICKAXE || mat == Material.DIAMOND_SPADE || mat == Material.DIAMOND_SWORD;
    }

    private boolean isIronMaterial(Material mat) {
        return mat == Material.IRON_AXE || mat == Material.IRON_BOOTS || mat == Material.IRON_CHESTPLATE || mat == Material.IRON_HELMET || mat == Material.IRON_HOE || mat == Material.IRON_LEGGINGS || mat == Material.IRON_PICKAXE || mat == Material.IRON_SPADE || mat == Material.IRON_SWORD;
    }
}

