/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.events.item;

import eu.scorpionltd.uhc.manager.langues.msg.MEnum;
import eu.scorpionltd.uhc.manager.settings.Settings;
import eu.scorpionltd.uhc.manager.settings.SettingsManager;
import eu.scorpionltd.uhc.manager.settings.values.ValueCategorie;
import eu.scorpionltd.uhc.manager.settings.values.Values;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.inventory.ItemStack;

public class CraftEvent
implements Listener {
    @EventHandler
    public void onCraft(CraftItemEvent e) {
        if (e.getRecipe() == null || e.getRecipe().getResult() == null || e.getRecipe().getResult().getType() == null) {
            return;
        }
        if (!Values.CUSTOMCRAFT_DOUBLEARROW.getBoolean()) {
            return;
        }
        ItemStack result = e.getRecipe().getResult();
        if (e.getCurrentItem() != null && e.getCurrentItem().getType() != null && e.getCurrentItem().getType() == result.getType() && result.getType() == Material.ARROW && e.getSlot() == 0) {
            e.setCurrentItem(new ItemStack(Material.ARROW, 8));
        }
    }

    @EventHandler
    public void onPrepareCraft(PrepareItemCraftEvent e) {
        if (e.getRecipe() == null || e.getRecipe().getResult() == null || e.getRecipe().getResult().getType() == null) {
            return;
        }
        ItemStack stack = e.getRecipe().getResult();
        if (stack.getType() == Material.GOLDEN_APPLE) {
            if (stack.getDurability() == 1) {
                if (!Values.CRAFT_GOLDEN_NOTCH.getBoolean()) {
                    CraftEvent.blockItemCraft(e);
                }
            } else if (!Values.CRAFT_GOLDEN_APPLE.getBoolean() && !stack.hasItemMeta()) {
                CraftEvent.blockItemCraft(e);
            }
            return;
        }
        if (!Values.CRAFT_SWORD.getBoolean() && stack.getType().name().toLowerCase().contains("_sword")) {
            CraftEvent.blockItemCraft(e);
            return;
        }
        if (!Values.CRAFT_PICKAXE.getBoolean() && stack.getType().name().toLowerCase().contains("_pickaxe")) {
            CraftEvent.blockItemCraft(e);
            return;
        }
        if (!Values.CRAFT_AXE.getBoolean() && stack.getType().name().toLowerCase().contains("_axe")) {
            CraftEvent.blockItemCraft(e);
            return;
        }
        if (!Values.CRAFT_SPADE.getBoolean() && stack.getType().name().toLowerCase().contains("_shovel")) {
            CraftEvent.blockItemCraft(e);
            return;
        }
        if (!Values.CRAFT_HOE.getBoolean() && stack.getType().name().toLowerCase().contains("_hoe")) {
            CraftEvent.blockItemCraft(e);
            return;
        }
        for (Settings param : SettingsManager.getSettings(ValueCategorie.CRAFT)) {
            if (((Boolean)param.getValue()).booleanValue() || stack.getType() != param.getVariable().getItemStack().getType()) continue;
            CraftEvent.blockItemCraft(e);
        }
        if (!Values.CUSTOMCRAFT_FIREWORK.getBoolean() && stack.getType() == Material.FIREWORK) {
            CraftEvent.blockItemCraft(e);
            return;
        }
    }

    public static void blockItemCraft(PrepareItemCraftEvent e) {
        e.getInventory().setResult(new ItemStack(Material.AIR));
        e.getViewers().forEach(viewer -> {
            if (viewer instanceof Player) {
                MEnum.EVENTS_BLOCK_CRAFT.sendTo((Player)viewer, new Object[0]);
            }
        });
    }
}

