/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.events.entity;

import eu.scorpionltd.uhc.manager.settings.config.ConfigFile;
import eu.scorpionltd.uhc.manager.settings.values.Values;
import eu.scorpionltd.uhc.manager.world.GameWorld;
import eu.scorpionltd.uhc.manager.world.GameWorldManager;
import eu.scorpionltd.uhc.util.entity.EntityItem;
import eu.scorpionltd.uhc.util.server.enums.Metadata;
import eu.scorpionltd.uhc.util.server.enums.Status;
import eu.scorpionltd.uhc.util.world.monde.LobbyUtil;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftLivingEntity;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDeathEvent;

public class SpawnEvent
implements Listener {
    private static int mobSpawn = 0;
    private static List<EntityType> bypassEntityType = new ArrayList<EntityType>();

    public static int getMobSpawn() {
        return mobSpawn;
    }

    public static List<EntityType> getBypassEntityType() {
        return bypassEntityType;
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGH)
    public void onCreatureDeath(EntityDeathEvent e) {
        if (e.getEntity() == null || e.getEntity() instanceof Player || e.getEntity() instanceof ArmorStand) {
            return;
        }
        --mobSpawn;
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGH)
    public void onCreatureSpawn(CreatureSpawnEvent e) {
        if (e.getEntity() == null || e.getEntity() instanceof Player || e.getEntity() instanceof ArmorStand) {
            return;
        }
        LivingEntity ent = e.getEntity();
        Location loc = e.getEntity().getLocation();
        World world = loc.getWorld();
        if (world == LobbyUtil.getLobbyWorld() && !Values.LOBBY_SPAWN_MOBS.getBoolean()) {
            e.setCancelled(true);
            ent.remove();
            return;
        }
        if (bypassEntityType.contains(ent.getType())) {
            return;
        }
        GameWorld gameWorld = GameWorldManager.getGameWorld(world);
        if (gameWorld != null && gameWorld.isCustomWorld()) {
            return;
        }
        if (!Status.getCurrentStatus().isStart() || Metadata.BYPASS_SPAWNLIMIT.has((Entity)ent)) {
            if (ent instanceof LivingEntity) {
                ((CraftLivingEntity)ent).setRemoveWhenFarAway(true);
            }
            return;
        }
        if (Math.round(loc.getBlockX()) > Values.BORDER_SIZE_INIT.getInteger() || Math.round(loc.getZ()) > (long)Values.BORDER_SIZE_INIT.getInteger()) {
            e.setCancelled(true);
            ent.remove();
            return;
        }
        if (ConfigFile.INGAME_MOB_LIMIT.getBoolean() && mobSpawn >= ConfigFile.INGAME_MOB_NUMBER.getInteger()) {
            e.setCancelled(true);
            ent.remove();
            return;
        }
        CreatureSpawnEvent.SpawnReason reason = e.getSpawnReason();
        if (!Values.ENTITY_LIGHTNING_EFFECT.getBoolean() && reason == CreatureSpawnEvent.SpawnReason.LIGHTNING) {
            e.setCancelled(true);
            ent.remove();
            return;
        }
        if (!(Values.ENTITY_JOCKEY.getBoolean() || reason != CreatureSpawnEvent.SpawnReason.JOCKEY && reason != CreatureSpawnEvent.SpawnReason.MOUNT)) {
            e.setCancelled(true);
            ent.remove();
            return;
        }
        if (!Values.ENTITY_SLIME_SPLIT.getBoolean() && reason == CreatureSpawnEvent.SpawnReason.SLIME_SPLIT) {
            e.setCancelled(true);
            ent.remove();
            return;
        }
        if (!Values.ENTITY_SILVERFISH_BLOCK.getBoolean() && reason == CreatureSpawnEvent.SpawnReason.SILVERFISH_BLOCK) {
            e.setCancelled(true);
            ent.remove();
            return;
        }
        if (Values.ENTITY_PIG_REPLACE.getBoolean() && ent.getType() == EntityType.PIG) {
            e.setCancelled(true);
            ent.remove();
            loc.getWorld().spawnEntity(loc, EntityType.COW);
            return;
        }
        if (Values.ENTITY_SHEEP_REPLACE.getBoolean() && ent.getType() == EntityType.SHEEP) {
            e.setCancelled(true);
            ent.remove();
            loc.getWorld().spawnEntity(loc, EntityType.COW);
            return;
        }
        for (EntityItem value : EntityItem.values()) {
            if (value.getType() != ent.getType() || value.getValue()) continue;
            e.setCancelled(true);
            ent.remove();
            return;
        }
        if (ent instanceof LivingEntity) {
            ent.setRemoveWhenFarAway(true);
        }
        ++mobSpawn;
    }
}

