/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.events.entity;

import eu.scorpionltd.utils.item.loot.Loot;
import eu.scorpionltd.utils.item.loot.LootItem;
import eu.scorpionltd.utils.item.loot.VarsLoot;
import java.util.HashMap;
import java.util.Random;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.inventory.ItemStack;

public class EntityLootEvent
implements Listener {
    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onEntityDeath(EntityDeathEvent e) {
        Player player;
        ItemStack hand;
        EntityType type;
        LivingEntity ent = e.getEntity();
        if (ent instanceof Player) {
            return;
        }
        HashMap loots = VarsLoot.getEntitiesLoots();
        if (!loots.containsKey(type = ent.getType())) {
            return;
        }
        Loot loot = (Loot)loots.get(type);
        e.setDroppedExp((int)(loot.getExp() * (double)e.getDroppedExp()));
        e.getDrops().clear();
        double multiplicateur = 1.0;
        boolean fireMob = e.getEntity().getFireTicks() != 0;
        boolean bl = fireMob;
        if (e.getEntity().getKiller() != null && e.getEntity().getKiller() instanceof Player && (hand = (player = e.getEntity().getKiller()).getItemInHand()) != null && hand.containsEnchantment(Enchantment.LOOT_BONUS_MOBS)) {
            multiplicateur += 0.5 * (double)hand.getEnchantmentLevel(Enchantment.LOOT_BONUS_MOBS);
        }
        for (LootItem item : loot.getLoots()) {
            ItemStack lootItem = item.getLootItem();
            if (lootItem == null || lootItem.getType() == Material.AIR || lootItem.getAmount() <= 0) continue;
            double calcul = (double)lootItem.getAmount() * (new Random().nextBoolean() ? Math.ceil(multiplicateur) : Math.floor(multiplicateur));
            lootItem.setAmount((int)calcul);
            if (fireMob) {
                switch (lootItem.getType()) {
                    case PORK: {
                        lootItem.setType(Material.GRILLED_PORK);
                        break;
                    }
                    case RABBIT: {
                        lootItem.setType(Material.COOKED_RABBIT);
                        break;
                    }
                    case RAW_BEEF: {
                        lootItem.setType(Material.COOKED_BEEF);
                        break;
                    }
                    case RAW_CHICKEN: {
                        lootItem.setType(Material.COOKED_CHICKEN);
                        break;
                    }
                    case RAW_FISH: {
                        lootItem.setType(Material.COOKED_FISH);
                        break;
                    }
                    case MUTTON: {
                        lootItem.setType(Material.COOKED_MUTTON);
                    }
                }
            }
            e.getDrops().add(lootItem);
        }
    }
}

