/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.events.entity;

import eu.scorpionltd.uhc.manager.players.UHCPlayerManager;
import eu.scorpionltd.uhc.manager.settings.config.ConfigFile;
import eu.scorpionltd.uhc.manager.settings.values.Values;
import eu.scorpionltd.uhc.scoreboard.ScoreboardLife;
import eu.scorpionltd.uhc.tasks.Timer;
import eu.scorpionltd.uhc.tasks.TimerManager;
import eu.scorpionltd.uhc.util.chat.ChatUtil;
import eu.scorpionltd.uhc.util.server.enums.Metadata;
import eu.scorpionltd.uhc.util.server.enums.Status;
import eu.scorpionltd.uhc.util.world.border.BorderUtil;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;

public class DamageEvent
implements Listener {
    @EventHandler
    public void onDamage(EntityDamageEvent e) {
        if (e.getEntity() == null || !(e.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)e.getEntity();
        if (!Status.getCurrentStatus().isStart() || player.getGameMode() == GameMode.ADVENTURE || UHCPlayerManager.getPlayer(player.getUniqueId()).isDead()) {
            e.setCancelled(true);
            return;
        }
        if (Metadata.NO_DAMAGE.has(player) || Metadata.FIRST_DAMAGE.has(player)) {
            e.setCancelled(true);
            if (Metadata.FIRST_DAMAGE.has(player)) {
                Metadata.FIRST_DAMAGE.remove(player);
            }
            return;
        }
        if (e.getCause() == EntityDamageEvent.DamageCause.LIGHTNING && (Metadata.FIRST_LIGHTNING.has(player) || Metadata.NO_LIGHTNING.has(player))) {
            e.setCancelled(true);
            if (Metadata.FIRST_LIGHTNING.has(player)) {
                Metadata.FIRST_LIGHTNING.remove(player);
            }
            return;
        }
        if (e.getCause() == EntityDamageEvent.DamageCause.POISON && (Metadata.FIRST_POISON.has(player) || Metadata.NO_POISON.has(player))) {
            e.setCancelled(true);
            if (Metadata.FIRST_POISON.has(player)) {
                Metadata.FIRST_POISON.remove(player);
            }
            return;
        }
        if (e.getCause() == EntityDamageEvent.DamageCause.FALL && (Metadata.FIRST_FALL.has(player) || Metadata.NO_FALL.has(player))) {
            e.setCancelled(true);
            if (Metadata.FIRST_FALL.has(player)) {
                Metadata.FIRST_FALL.remove(player);
            }
            return;
        }
        if ((e.getCause() == EntityDamageEvent.DamageCause.BLOCK_EXPLOSION || e.getCause() == EntityDamageEvent.DamageCause.ENTITY_EXPLOSION) && (Metadata.FIRST_EXPLOSION.has(player) || Metadata.NO_EXPLOSION.has(player))) {
            e.setCancelled(true);
            if (Metadata.FIRST_EXPLOSION.has(player)) {
                Metadata.FIRST_EXPLOSION.remove(player);
            }
            return;
        }
        if ((e.getCause() == EntityDamageEvent.DamageCause.FIRE || e.getCause() == EntityDamageEvent.DamageCause.FIRE_TICK || e.getCause() == EntityDamageEvent.DamageCause.LAVA) && (Metadata.FIRST_FIRE.has(player) || Metadata.NO_FIRE.has(player))) {
            e.setCancelled(true);
            if (Metadata.FIRST_FIRE.has(player)) {
                Metadata.FIRST_FIRE.remove(player);
            }
            return;
        }
        if (e.getCause() == EntityDamageEvent.DamageCause.SUFFOCATION && this.hasObsidianInHead(player) && !Values.RULES_OBSITRAP.getBoolean()) {
            Block block = player.getLocation().getBlock().getRelative(BlockFace.UP);
            block.setType(Material.AIR);
            if (ConfigFile.ALERTS_OBSITRAP.getBoolean()) {
                ChatUtil.sendAlert(ChatUtil.getAlert("ObsiTrap", player.getName(), player.getPlayer().getLocation()));
            }
            e.setCancelled(true);
            return;
        }
        Timer timer = TimerManager.getTimerByKey(Values.TIMERS_DEGATS);
        if (timer != null && timer.isActive()) {
            e.setCancelled(true);
            return;
        }
        if (Values.BORDER_TYPE.getInteger() == 1 && e.getCause() == EntityDamageEvent.DamageCause.SUFFOCATION && BorderUtil.isOutside(player) != 0) {
            e.setCancelled(true);
            BorderUtil.teleportPlayerInBorder(player);
        }
        ScoreboardLife.updateHealth(player);
    }

    private boolean hasObsidianInHead(Player player) {
        if (player.getLocation() == null || player.getLocation().getBlock() == null) {
            return false;
        }
        Block block = player.getLocation().getBlock().getRelative(BlockFace.UP);
        return block != null && block.getType() != null && block.getType() == Material.OBSIDIAN;
    }
}

