/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.events.custom.item;

import eu.scorpionltd.uhc.manager.players.UHCPlayer;
import eu.scorpionltd.uhc.manager.players.UHCPlayerManager;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;

public class GameInteractEvent
extends Event {
    private static final HandlerList handlers = new HandlerList();
    private UHCPlayer player;
    private Action action;
    public Block block;
    private ItemStack item;
    private PlayerInteractEvent event;
    private boolean cancelEvent;

    public GameInteractEvent(Player player, PlayerInteractEvent event) {
        this.player = UHCPlayerManager.getPlayer(player);
        this.action = event.getAction();
        this.block = event.getClickedBlock();
        this.item = event.getItem();
        this.event = event;
        this.cancelEvent = false;
    }

    public UHCPlayer getUHCPlayer() {
        return this.player;
    }

    public Action getAction() {
        return this.action;
    }

    public boolean isLeftClick() {
        return this.action == Action.LEFT_CLICK_AIR || this.action == Action.LEFT_CLICK_BLOCK;
    }

    public boolean isRightClick() {
        return this.action == Action.RIGHT_CLICK_AIR || this.action == Action.RIGHT_CLICK_BLOCK;
    }

    public Block getBlock() {
        return this.block;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public void setCancelled(boolean cancelEvent) {
        this.cancelEvent = cancelEvent;
        this.event.setCancelled(cancelEvent);
        this.event.setUseInteractedBlock(cancelEvent ? Event.Result.DENY : Event.Result.ALLOW);
        this.event.setUseItemInHand(cancelEvent ? Event.Result.DENY : Event.Result.ALLOW);
    }

    public boolean isCancelled() {
        return this.cancelEvent;
    }

    public PlayerInteractEvent getInteractEvent() {
        return this.event;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    public HandlerList getHandlers() {
        return handlers;
    }
}

