/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.events.block;

import eu.scorpionltd.uhc.manager.langues.msg.MEnum;
import eu.scorpionltd.uhc.manager.players.UHCPlayerManager;
import eu.scorpionltd.uhc.manager.settings.SettingsManager;
import eu.scorpionltd.uhc.manager.settings.values.ValueCategorie;
import eu.scorpionltd.uhc.manager.settings.values.Values;
import eu.scorpionltd.uhc.util.server.enums.Metadata;
import eu.scorpionltd.uhc.util.server.enums.Status;
import eu.scorpionltd.uhc.util.world.WorldUtil;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPlaceEvent;

public class PlaceEvent
implements Listener {
    private final int MAX = 10;

    @EventHandler
    public void onPlace(BlockPlaceEvent e) {
        if (e.getPlayer() == null || e.getBlock() == null || e.getBlock().getType() == null) {
            return;
        }
        Status status = Status.getCurrentStatus();
        if (!status.isStart() && !UHCPlayerManager.getPlayer(e.getPlayer()).isBypassMode()) {
            e.setCancelled(true);
            e.getPlayer().updateInventory();
            return;
        }
        if (Values.TEAM_MYSTERY_TEAM.getBoolean() && (e.getBlock().getType() == Material.BANNER || e.getBlock().getType() == Material.STANDING_BANNER || e.getBlock().getType() == Material.WALL_BANNER)) {
            e.setCancelled(true);
            e.getPlayer().updateInventory();
            return;
        }
        if (Metadata.CANT_PLACED_BLOCKS.has(e.getPlayer())) {
            e.setCancelled(true);
            e.getPlayer().updateInventory();
            return;
        }
        this.checkTowers(e);
    }

    private void checkTowers(BlockPlaceEvent e) {
        boolean highEnough;
        World.Environment env = WorldUtil.getEnv(e.getPlayer().getWorld());
        ValueCategorie cat = env == World.Environment.NORMAL ? ValueCategorie.OVERWORLD : (env == World.Environment.NETHER ? ValueCategorie.NETHER : ValueCategorie.END);
        boolean towersDisabled = (Boolean)SettingsManager.getSettings(cat, Material.COBBLESTONE).getValue();
        if (towersDisabled) {
            return;
        }
        Block block = e.getBlock();
        Player player = e.getPlayer();
        Location loc = block.getLocation();
        boolean isSurface = WorldUtil.isSurface(loc);
        boolean isTop = loc.equals((Object)loc.getWorld().getHighestBlockAt(loc).getLocation());
        boolean bl = highEnough = loc.getBlockY() >= loc.getWorld().getSeaLevel();
        if (isTop && highEnough && isSurface) {
            int nb;
            Location below = loc.clone().subtract(0.0, 1.0, 0.0);
            for (nb = 0; Metadata.PLACED_BLOCKS.has(below.getBlock()) && nb < 10; ++nb) {
                below.subtract(0.0, 1.0, 0.0);
            }
            if (nb >= 10) {
                e.setCancelled(true);
                MEnum.EVENTS_NO_TOWERS.sendTo(player, new Object[0]);
            } else {
                Metadata.PLACED_BLOCKS.add(block);
            }
        } else {
            Metadata.PLACED_BLOCKS.add(block);
        }
    }
}

