/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.events.block;

import eu.scorpionltd.uhc.manager.langues.msg.MEnum;
import eu.scorpionltd.uhc.manager.players.UHCPlayer;
import eu.scorpionltd.uhc.manager.players.UHCPlayerManager;
import eu.scorpionltd.uhc.manager.settings.values.Values;
import eu.scorpionltd.uhc.util.player.InventoryUtil;
import eu.scorpionltd.uhc.util.server.enums.Metadata;
import eu.scorpionltd.uhc.util.server.enums.Status;
import eu.scorpionltd.uhc.util.world.monde.LobbyUtil;
import java.util.Random;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;

public class BreakEvent
implements Listener {
    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOW)
    public void onBreak(BlockBreakEvent e) {
        if (e.getPlayer() == null || e.getBlock() == null) {
            return;
        }
        Status status = Status.getCurrentStatus();
        if (!status.isStart() && !UHCPlayerManager.getPlayer(e.getPlayer()).isBypassMode()) {
            e.setCancelled(true);
            return;
        }
        if (status.isStart() && e.getBlock().getWorld() == LobbyUtil.getLobbyWorld()) {
            e.setCancelled(true);
            return;
        }
        if (Metadata.NO_BREAKING.has(e.getBlock())) {
            e.setCancelled(true);
            return;
        }
        this.checkBlockLimit(e);
    }

    private void checkBlockLimit(BlockBreakEvent e) {
        if (e.getBlock().getType() != Material.DIAMOND_ORE && e.getBlock().getType() != Material.GOLD_ORE || Metadata.FAKE_DIAMONDS.has(e.getBlock())) {
            return;
        }
        Block b = e.getBlock();
        UHCPlayer up = UHCPlayerManager.getPlayer(e.getPlayer());
        if (b.getType() == Material.GOLD_ORE && Values.BLOCKS_GOLD_LIMITED.getBoolean()) {
            int limit = Values.BLOCKS_GOLD_NUMBER.getInteger();
            if (up.getInfos().getCurrentGolds() > limit) {
                e.setCancelled(true);
                int amount = this.getQuantitiesLessOre();
                if (amount == 0) {
                    MEnum.EVENTS_ORE_LIMIT.send(up, limit);
                    return;
                }
                e.getBlock().setType(Material.AIR);
                InventoryUtil.dropItem(b.getLocation(), new ItemStack(Material.IRON_ORE, amount));
            }
            return;
        }
        if (b.getType() == Material.DIAMOND_ORE && Values.BLOCKS_DIAMOND_LIMITED.getBoolean()) {
            int limit = Values.BLOCKS_DIAMOND_NUMBER.getInteger();
            if (up.getInfos().getCurrentDiamonds() > limit) {
                e.setCancelled(true);
                int amount = this.getQuantitiesLessOre();
                if (amount == 0) {
                    MEnum.EVENTS_ORE_LIMIT.send(up, limit);
                    return;
                }
                e.getBlock().setType(Material.AIR);
                InventoryUtil.dropItem(b.getLocation(), new ItemStack(Material.GOLD_ORE, amount));
            }
            return;
        }
    }

    private int getQuantitiesLessOre() {
        int lessore = Values.BLOCKS_GIVE_LESS_ORE_AFTER_LIMIT.getInteger();
        if (lessore == 1) {
            return new Random().nextBoolean() ? 0 : 1;
        }
        if (lessore == 2) {
            return 1;
        }
        if (lessore == 3) {
            return new Random().nextBoolean() ? 1 : 2;
        }
        if (lessore == 4) {
            return 2;
        }
        return 0;
    }
}

