/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.events.block;

import eu.scorpionltd.uhc.util.server.enums.Metadata;
import eu.scorpionltd.uhc.util.server.enums.Status;
import eu.scorpionltd.uhc.util.world.BlockUtil;
import java.util.ArrayList;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.LeavesDecayEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.inventory.ItemStack;

public class BlockLootEvent
implements Listener {
    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onDepop(LeavesDecayEvent e) {
        if (e.getBlock() == null) {
            return;
        }
        boolean isLootable = BlockUtil.checkBlock(e.getBlock(), null);
        if (!isLootable) {
            return;
        }
        e.setCancelled(true);
        e.getBlock().setType(Material.AIR);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onBreak(BlockBreakEvent e) {
        if (e.getBlock() == null || e.getBlock().getType() == Material.AIR || e.getPlayer() == null) {
            return;
        }
        if (e.getBlock().getType() == Material.DIAMOND_ORE && Metadata.FAKE_DIAMONDS.has(e.getBlock())) {
            e.getBlock().setType(Material.AIR);
            Metadata.FAKE_DIAMONDS.remove(e.getBlock());
            return;
        }
        Block b = e.getBlock();
        Player p = e.getPlayer();
        boolean isLootable = BlockUtil.checkBlock(b, e);
        if (!isLootable) {
            return;
        }
        e.setCancelled(true);
        b.setType(Material.AIR);
        ItemStack item = p.getItemInHand();
        if (item != null && item.getType() != Material.AIR && item.getType().getMaxDurability() > 0 && (!item.hasItemMeta() || item.hasItemMeta() && !item.getItemMeta().spigot().isUnbreakable())) {
            if (item.getDurability() + 1 >= item.getType().getMaxDurability()) {
                e.getPlayer().getInventory().removeItem(new ItemStack[]{item});
                e.getPlayer().updateInventory();
                e.getPlayer().playSound(e.getPlayer().getLocation(), Sound.ITEM_BREAK, 1.0f, 1.0f);
            } else {
                item.setDurability((short)(item.getDurability() + 1));
            }
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onExplode(EntityExplodeEvent e) {
        if (!Status.getCurrentStatus().isStart()) {
            e.setCancelled(true);
            return;
        }
        for (Block block : new ArrayList(e.blockList())) {
            boolean isLootable = BlockUtil.checkBlock(block, null);
            if (!isLootable) continue;
            e.blockList().remove(block);
            block.setType(Material.AIR);
        }
    }
}

