/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.events.alert;

import eu.scorpionltd.uhc.manager.players.UHCPlayer;
import eu.scorpionltd.uhc.manager.players.UHCPlayerManager;
import eu.scorpionltd.uhc.util.MethsUtil;
import eu.scorpionltd.uhc.util.chat.ChatUtil;
import eu.scorpionltd.uhc.util.world.WorldUtil;
import java.util.HashMap;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;

public class Stripmining
implements Listener {
    private HashMap<UHCPlayer, String> checkStripmining = new HashMap();

    private boolean isStripMining(UHCPlayer p) {
        return this.checkStripmining.containsKey(p);
    }

    private String getStripMining(UHCPlayer p) {
        return this.checkStripmining.get(p);
    }

    private void addStripMining(UHCPlayer p, String valeur) {
        this.checkStripmining.put(p, valeur);
    }

    private void removeStripMining(UHCPlayer p) {
        if (!this.isStripMining(p)) {
            return;
        }
        this.checkStripmining.remove(p);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onBreak(BlockBreakEvent e) {
        if (e.getPlayer() == null || e.getBlock() == null) {
            return;
        }
        Player player = e.getPlayer();
        Location loc = player.getLocation();
        if (loc.getBlockY() > 32 || WorldUtil.getEnv(loc) != World.Environment.NORMAL) {
            return;
        }
        UHCPlayer p = UHCPlayerManager.getPlayer(player);
        boolean checkStripMine = this.checkAround(player, loc.getBlockY());
        if (!checkStripMine) {
            this.removeStripMining(p);
            return;
        }
        if (!this.isStripMining(p)) {
            this.addStripMining(p, "Y=" + loc.getBlockY() + "/" + 1);
            return;
        }
        String valeur = this.getStripMining(p);
        int blockY = Integer.parseInt(valeur.split("/")[0].split("=")[1]);
        int checks = Integer.parseInt(valeur.split("/")[1]);
        if (loc.getBlockY() != blockY) {
            this.removeStripMining(p);
            return;
        }
        if (checks < 10) {
            int newChecks = checks + 1;
            this.addStripMining(p, "Y=" + blockY + "/" + newChecks);
        } else {
            this.preventStaff(p);
            this.removeStripMining(p);
        }
    }

    private boolean checkAround(Player p, int y) {
        boolean result = false;
        Block joueurY1 = p.getLocation().getBlock();
        Block joueurY2 = p.getLocation().add(0.0, 1.0, 0.0).getBlock();
        if (MethsUtil.getFacing(p) == "South" || MethsUtil.getFacing(p) == "North") {
            Block leftY1 = joueurY1.getLocation().add(1.0, 0.0, 0.0).getBlock();
            Block leftY2 = joueurY2.getLocation().add(1.0, 0.0, 0.0).getBlock();
            Block rightY1 = joueurY1.getLocation().add(-1.0, 0.0, 0.0).getBlock();
            Block rightY2 = joueurY2.getLocation().add(-1.0, 0.0, 0.0).getBlock();
            if (joueurY1.getRelative(BlockFace.DOWN).getType() != Material.AIR && leftY1.getType() != Material.AIR && rightY1.getType() != Material.AIR && joueurY2.getRelative(BlockFace.UP).getType() != Material.AIR && leftY2.getType() != Material.AIR && rightY2.getType() != Material.AIR) {
                result = true;
            }
        } else if ((MethsUtil.getFacing(p) == "West" || MethsUtil.getFacing(p) == "East") && joueurY1.getRelative(BlockFace.DOWN).getType() != Material.AIR && joueurY1.getRelative(BlockFace.SOUTH).getType() != Material.AIR && joueurY1.getRelative(BlockFace.NORTH).getType() != Material.AIR && joueurY2.getRelative(BlockFace.UP).getType() != Material.AIR && joueurY2.getRelative(BlockFace.SOUTH).getType() != Material.AIR && joueurY2.getRelative(BlockFace.NORTH).getType() != Material.AIR) {
            result = true;
        }
        return result;
    }

    private void preventStaff(UHCPlayer p) {
        ChatUtil.sendAlert(ChatUtil.getAlert("StripMining", p.getName(), p.getPlayer().getLocation()));
    }
}

