/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.events.alert;

import eu.scorpionltd.uhc.manager.players.UHCPlayer;
import eu.scorpionltd.uhc.manager.players.UHCPlayerManager;
import eu.scorpionltd.uhc.util.chat.ChatUtil;
import eu.scorpionltd.uhc.util.server.enums.Metadata;
import java.util.ArrayList;
import java.util.List;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;

public class DiamondMining
implements Listener {
    private List<Block> diamondCheck = new ArrayList<Block>();

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOW)
    public void onBreak(BlockBreakEvent e) {
        if (e.getBlock() == null || e.getPlayer() == null || e.getBlock().getType() != Material.DIAMOND_ORE || this.diamondCheck.contains(e.getBlock())) {
            return;
        }
        ArrayList<Block> diamondFilon = new ArrayList<Block>();
        this.countBlocks(e.getBlock(), diamondFilon);
        UHCPlayer player = UHCPlayerManager.getPlayer(e.getPlayer());
        String diamondText = ChatColor.DARK_GRAY + " (" + ChatColor.DARK_AQUA + "T=" + ChatColor.AQUA + player.getInfos().getCurrentDiamonds() + ChatColor.DARK_GRAY + ")";
        boolean isFake = Metadata.FAKE_DIAMONDS.has(e.getBlock());
        String fakeText = ChatColor.WHITE + "" + ChatColor.BOLD + " (FAKE)";
        TextComponent component = ChatUtil.getAlert(e.getPlayer().getName(), diamondFilon.size() + " diamonds" + (isFake ? fakeText : diamondText), e.getPlayer().getLocation());
        ChatUtil.sendAlert(component);
    }

    private void countBlocks(Block b, List<Block> diamondFilon) {
        if (b == null || b.getType() != Material.DIAMOND_ORE || diamondFilon.contains(b)) {
            return;
        }
        diamondFilon.add(b);
        this.diamondCheck.add(b);
        for (BlockFace face : BlockFace.values()) {
            if (face == BlockFace.SELF) continue;
            this.countBlocks(b.getRelative(face), diamondFilon);
        }
    }
}

