/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.events.alert;

import eu.scorpionltd.uhc.UHC;
import eu.scorpionltd.uhc.manager.langues.msg.MEnum;
import eu.scorpionltd.uhc.manager.players.UHCPlayer;
import eu.scorpionltd.uhc.manager.players.UHCPlayerManager;
import eu.scorpionltd.uhc.manager.settings.config.ConfigFile;
import eu.scorpionltd.uhc.util.chat.ChatUtil;
import java.util.HashMap;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class CombatLog
implements Listener {
    public static HashMap<UHCPlayer, Integer> inCombat = new HashMap();

    public static boolean isInCombat(UHCPlayer player) {
        return inCombat.containsKey(player);
    }

    private int getInCombat(UHCPlayer player) {
        return inCombat.get(player);
    }

    private void addInCombat(UHCPlayer player, int seconds) {
        inCombat.put(player, seconds);
    }

    private void removeInCombat(UHCPlayer player) {
        if (!CombatLog.isInCombat(player)) {
            return;
        }
        inCombat.remove(player);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onDamageEntity(EntityDamageByEntityEvent e) {
        if (e.getEntity() == null || !(e.getEntity() instanceof Player) || e.getDamager() == null || !(e.getDamager() instanceof Player)) {
            return;
        }
        Player victime = (Player)e.getEntity();
        Player killer = (Player)e.getDamager();
        UHCPlayer uv = UHCPlayerManager.getPlayer(victime.getUniqueId());
        UHCPlayer uk = UHCPlayerManager.getPlayer(killer.getUniqueId());
        if (uv == null || uk == null || !uv.isPlaying() || !uk.isPlaying()) {
            return;
        }
        int seconds = ConfigFile.COMBATLOG_TIME.getInteger();
        if (!CombatLog.isInCombat(uv)) {
            this.startCooldownTimer(uv, seconds);
            this.preventStaff(uv, uk, victime.getLocation());
        }
        this.addInCombat(uv, seconds);
        if (!CombatLog.isInCombat(uk)) {
            this.startCooldownTimer(uk, seconds);
        }
        this.addInCombat(uk, seconds);
    }

    private void startCooldownTimer(final UHCPlayer p, int seconds) {
        this.addInCombat(p, seconds);
        new BukkitRunnable(){

            public void run() {
                if (!CombatLog.isInCombat(p) || CombatLog.this.getInCombat(p) <= 0) {
                    this.cancel();
                    MEnum.EVENTS_NO_COMBATLOG.send(p, new Object[0]);
                    CombatLog.this.removeInCombat(p);
                    return;
                }
                int time = CombatLog.this.getInCombat(p);
                MEnum.EVENTS_COMBATLOG.send(p, time);
                CombatLog.this.addInCombat(p, time - 1);
            }
        }.runTaskTimer((Plugin)UHC.getInstance(), 20L, 20L);
    }

    private void preventStaff(UHCPlayer victime, UHCPlayer killer, Location loc) {
        ChatUtil.sendAlert(ChatUtil.getAlert("Fight " + killer.getName(), victime.getName(), loc));
    }
}

