/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.commands.spec;

import eu.scorpionltd.annotations.commands.Command;
import eu.scorpionltd.annotations.commands.CommandArgs;
import eu.scorpionltd.uhc.manager.langues.msg.MEnum;
import eu.scorpionltd.uhc.manager.players.UHCPlayer;
import eu.scorpionltd.uhc.manager.players.UHCPlayerManager;
import eu.scorpionltd.uhc.manager.players.permissions.Permissions;
import eu.scorpionltd.uhc.manager.settings.config.ConfigFile;
import eu.scorpionltd.uhc.util.world.monde.LobbyUtil;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.entity.Player;

public class SpecCommand {
    @Command(name="spec", description="Gerer les specs", usage="Commande: /spec <add|remove> <Pseudo>")
    public void onCommand(CommandArgs args) {
        if (!(args.getSender() instanceof Player)) {
            return;
        }
        Player p = args.getPlayer();
        if (!Permissions.SPEC_CMD.hasPerm(p)) {
            MEnum.NO_PERMISSION.sendTo(p, new Object[0]);
            return;
        }
        if (args.length() != 2 || !args.getArgs(0).equalsIgnoreCase("add") && !args.getArgs(0).equalsIgnoreCase("remove")) {
            MEnum.SPEC_USE.sendTo(p, new Object[0]);
            return;
        }
        Player target = Bukkit.getPlayer((String)args.getArgs(1));
        if (target == null || !target.isOnline()) {
            MEnum.NO_CONNECTED.sendTo(p, new Object[0]);
            return;
        }
        UHCPlayer utarget = UHCPlayerManager.getPlayer(target.getUniqueId());
        if (args.getArgs(0).equalsIgnoreCase("add")) {
            if (utarget.isSpec()) {
                MEnum.ALREADY_SPEC.sendTo(p, new Object[0]);
                return;
            }
            MEnum.ADD_SPEC.sendTo(p, utarget.getName());
            MEnum.JOIN_SPEC.sendTo(target, p.getName());
            target.setPlayerListName(ConfigFile.TEXT_SPEC_HOST.getString() + target.getName());
            target.setGameMode(GameMode.SPECTATOR);
            utarget.setSpec(true);
            target.teleport(p.getLocation());
            return;
        }
        if (!utarget.isSpec()) {
            MEnum.NO_SPEC.sendTo(p, new Object[0]);
            return;
        }
        MEnum.REMOVE_SPEC.sendTo(p, utarget.getName());
        MEnum.LEAVE_SPEC.sendTo(target, p.getName());
        target.setPlayerListName(target.getDisplayName());
        target.setGameMode(GameMode.ADVENTURE);
        utarget.setSpec(false);
        target.teleport(LobbyUtil.getLobbyLocation());
    }
}

