/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.commands.spec;

import eu.scorpionltd.annotations.commands.Command;
import eu.scorpionltd.annotations.commands.CommandArgs;
import eu.scorpionltd.uhc.manager.langues.msg.MEnum;
import eu.scorpionltd.uhc.manager.players.UHCPlayer;
import eu.scorpionltd.uhc.manager.players.UHCPlayerManager;
import eu.scorpionltd.uhc.manager.players.permissions.Permissions;
import eu.scorpionltd.uhc.manager.settings.config.ConfigFile;
import eu.scorpionltd.uhc.util.world.monde.LobbyUtil;
import org.bukkit.GameMode;
import org.bukkit.entity.Player;

public class JoinSpecCommand {
    @Command(name="joinspec", description="Join spectator", usage="Commande: /joinspec")
    public void onJoinSpecCommand(CommandArgs args) {
        if (!(args.getSender() instanceof Player)) {
            return;
        }
        Player p = args.getPlayer();
        if (!Permissions.JOIN_SPEC_CMD.hasPerm(p)) {
            MEnum.NO_PERMISSION.sendTo(p, new Object[0]);
            return;
        }
        UHCPlayer up = UHCPlayerManager.getPlayer(p);
        if (up.isSpec()) {
            MEnum.ALREADY_SPEC.sendTo(p, new Object[0]);
            return;
        }
        up.setSpec(true);
        MEnum.JOIN_SPEC.sendTo(p, p.getName());
        p.setPlayerListName(ConfigFile.TEXT_SPEC_HOST.getString() + p.getName());
        p.setGameMode(GameMode.SPECTATOR);
        p.teleport(p.getLocation());
    }

    @Command(name="leavespec", description="Leave spectator", usage="Commande: /leavespec")
    public void onLeaveSpecCommand(CommandArgs args) {
        if (!(args.getSender() instanceof Player)) {
            return;
        }
        Player p = args.getPlayer();
        if (!Permissions.JOIN_SPEC_CMD.hasPerm(p)) {
            MEnum.NO_PERMISSION.sendTo(p, new Object[0]);
            return;
        }
        UHCPlayer up = UHCPlayerManager.getPlayer(p);
        if (!up.isSpec()) {
            MEnum.NO_SPEC.sendTo(p, new Object[0]);
            return;
        }
        up.setSpec(false);
        MEnum.LEAVE_SPEC.sendTo(p, p.getName());
        p.setPlayerListName(p.getDisplayName());
        p.setGameMode(GameMode.ADVENTURE);
        p.teleport(LobbyUtil.getLobbyLocation());
    }
}

