/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.commands.player.team;

import eu.scorpionltd.annotations.commands.Command;
import eu.scorpionltd.annotations.commands.CommandArgs;
import eu.scorpionltd.uhc.UHC;
import eu.scorpionltd.uhc.manager.langues.msg.MEnum;
import eu.scorpionltd.uhc.manager.players.UHCPlayer;
import eu.scorpionltd.uhc.manager.players.UHCPlayerManager;
import eu.scorpionltd.uhc.manager.settings.values.Values;
import eu.scorpionltd.uhc.manager.teams.UHCTeam;
import eu.scorpionltd.uhc.util.server.enums.Status;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

public class TeamCommand {
    @Command(name="team", description="Manage teams (Captains Mode)", usage="Usage: /team")
    public void onTeamCommand(CommandArgs args) {
        if (!(args.getSender() instanceof Player) || Status.getCurrentStatus() != Status.WAITING) {
            return;
        }
        if (Values.TEAM_MODE.getInteger() == 0 || !UHC.getTeamManager().isChoosedTeam()) {
            return;
        }
        Player p = args.getPlayer();
        UHCPlayer up = UHCPlayerManager.getPlayer(p.getUniqueId());
        if (args.getArgs().length == 0) {
            this.sendHelpMessage(p, up);
            return;
        }
        String arg1 = args.getArgs(0);
        if (arg1.equalsIgnoreCase("create")) {
            UHCTeam team = UHC.getTeam(up);
            if (team != null) {
                MEnum.ALREADY_TEAM.sendTo(p, new Object[0]);
                return;
            }
            MEnum.CREATE_TEAM.sendTo(p, new Object[0]);
            new UHCTeam(up);
            return;
        }
        if (arg1.equalsIgnoreCase("delete")) {
            UHCTeam team = UHC.getTeam(up);
            if (team == null) {
                MEnum.NO_TEAM.sendTo(p, new Object[0]);
                return;
            }
            if (!team.isOwner(up)) {
                MEnum.NO_OWNER.sendTo(p, new Object[0]);
                return;
            }
            MEnum.DELETE_TEAM.sendTo(p, new Object[0]);
            team.removeTeam();
            return;
        }
        if (arg1.equalsIgnoreCase("leave")) {
            UHCTeam team = UHC.getTeam(up);
            if (team == null) {
                MEnum.NO_TEAM.sendTo(p, new Object[0]);
                return;
            }
            team.leave(up);
            return;
        }
        if (arg1.equalsIgnoreCase("list")) {
            UHCTeam team = UHC.getTeam(up);
            if (team == null) {
                MEnum.NO_TEAM.sendTo(p, new Object[0]);
                return;
            }
            MEnum.PRESENT_TEAM_LIST.sendTo(p, new Object[0]);
            team.getPlayers().forEach(players -> p.sendMessage(ChatColor.GRAY + "- " + ChatColor.AQUA + players.getName()));
            return;
        }
        if (args.length() != 2) {
            this.sendHelpMessage(p, up);
            return;
        }
        Player target = Bukkit.getPlayer((String)args.getArgs(1));
        if (target == null || !target.isOnline()) {
            MEnum.NO_CONNECTED.send(up, new Object[0]);
            return;
        }
        UHCPlayer ut = UHCPlayerManager.getPlayer(target);
        if (arg1.equalsIgnoreCase("invite")) {
            UHCTeam team = UHC.getTeam(up);
            if (team == null) {
                MEnum.NO_TEAM.sendTo(p, new Object[0]);
                return;
            }
            if (!team.isOwner(up)) {
                MEnum.NO_OWNER.sendTo(p, new Object[0]);
                return;
            }
            if (team.isFullTeam()) {
                MEnum.FULL_TEAM.sendTo(p, new Object[0]);
                return;
            }
            team.sendInvitation(ut);
            return;
        }
        if (arg1.equalsIgnoreCase("accept")) {
            UHCTeam team = UHC.getTeam(up);
            if (team != null) {
                MEnum.ALREADY_TEAM.sendTo(p, new Object[0]);
                return;
            }
            team = UHC.getTeam(ut);
            if (team == null) {
                MEnum.NO_TEAM.sendTo(p, new Object[0]);
                return;
            }
            if (!team.getPendingInvitations().contains(up)) {
                MEnum.NO_INVITATION.sendTo(p, new Object[0]);
                return;
            }
            if (team.isFullTeam()) {
                MEnum.FULL_TEAM.sendTo(p, new Object[0]);
                return;
            }
            team.add(up);
            return;
        }
        if (arg1.equalsIgnoreCase("kick")) {
            UHCTeam team = UHC.getTeam(up);
            if (team == null) {
                MEnum.NO_TEAM.sendTo(p, new Object[0]);
                return;
            }
            if (!team.isOwner(up)) {
                MEnum.NO_OWNER.sendTo(p, new Object[0]);
                return;
            }
            if (!team.getPlayers().contains(ut)) {
                MEnum.NOT_IN_TEAM.sendTo(p, ut.getName());
                return;
            }
            team.leave(ut);
            MEnum.KICK_TEAM.sendTeam(team, ut.getName());
            return;
        }
        this.sendHelpMessage(p, up);
    }

    public void sendHelpMessage(Player p, UHCPlayer up) {
        p.sendMessage("\u00a78\u00a7m----------------");
        p.sendMessage("\u00a73/team create \u00a78> \u00a76Create a team.");
        p.sendMessage("\u00a73/team leave \u00a78>  \u00a76 Leave your team.");
        p.sendMessage("\u00a73/team delete \u00a78> \u00a76Remove your team.");
        p.sendMessage("\u00a73/team list \u00a78> \u00a76Show players in your team.");
        p.sendMessage("\u00a73/team invite \u00a78(\u00a73Pseudo\u00a78) > \u00a76Invit a player in your team.");
        p.sendMessage("\u00a73/team accept \u00a78(\u00a73Pseudo\u00a78) > \u00a76Join a team.");
        p.sendMessage("\u00a73/team kick \u00a78(\u00a73Pseudo\u00a78) > \u00a76Kick a player in your team.");
        p.sendMessage("\u00a73/tcoords|/tc \u00a78> \u00a76Send location to your team.");
        p.sendMessage("\u00a73/tores|/to \u00a78> \u00a76Send ore's number to your team.");
        p.sendMessage("\u00a78\u00a7m----------------");
    }
}

