/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.commands.player.msg;

import eu.scorpionltd.annotations.commands.Command;
import eu.scorpionltd.annotations.commands.CommandArgs;
import eu.scorpionltd.uhc.manager.langues.msg.MEnum;
import eu.scorpionltd.uhc.manager.players.UHCPlayer;
import eu.scorpionltd.uhc.manager.players.UHCPlayerManager;
import eu.scorpionltd.uhc.manager.settings.values.Values;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class MsgCommand {
    private HashMap<UUID, UUID> lastReply = new HashMap();

    @Command(name="msg", description="Send private message", usage="Usage: /msg <Player> <Message>", aliases={"pm", "tell"})
    public void onCommand(CommandArgs args) {
        if (!(args.getSender() instanceof Player)) {
            return;
        }
        Player p = args.getPlayer();
        UHCPlayer up = UHCPlayerManager.getPlayer(p.getUniqueId());
        if (args.getArgs().length < 2) {
            MEnum.MSG_USE.send(up, new Object[0]);
            return;
        }
        Player target = Bukkit.getPlayer((String)args.getArgs(0));
        if (target == null || !target.isOnline()) {
            MEnum.NO_CONNECTED.send(up, new Object[0]);
            return;
        }
        UHCPlayer ut = UHCPlayerManager.getPlayer(target);
        if (!(Values.CHAT_PRIVATE_MESSAGE.getBoolean() || up.isHost() || up.isSpec() || ut.isHost() || ut.isSpec())) {
            MEnum.DISABLE_CMD.sendTo(p, new Object[0]);
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i < args.length(); ++i) {
            sb.append(args.getArgs(i));
            sb.append(" ");
        }
        String privateMessage = sb.toString();
        this.lastReply.put(target.getUniqueId(), p.getUniqueId());
        MEnum.MSG_SEND.send(up, ut.getName(), privateMessage, up.getName());
        MEnum.MSG_RECEIVE.send(ut, up.getName(), privateMessage, ut.getName());
    }

    @Command(name="r", description="Reply to a private message", usage="Usage: /r <Message>", aliases={"reply"})
    public void onReplyCommand(CommandArgs args) {
        if (!(args.getSender() instanceof Player)) {
            return;
        }
        Player p = args.getPlayer();
        if (!Values.CHAT_PRIVATE_MESSAGE.getBoolean()) {
            MEnum.DISABLE_CMD.sendTo(p, new Object[0]);
            return;
        }
        UHCPlayer up = UHCPlayerManager.getPlayer(p.getUniqueId());
        if (args.getArgs().length == 0) {
            MEnum.REPLY_USE.send(up, new Object[0]);
            return;
        }
        if (!this.lastReply.containsKey(p.getUniqueId())) {
            MEnum.REPLY_NO_LAST_MESSAGE.send(up, new Object[0]);
            return;
        }
        Player target = Bukkit.getPlayer((UUID)this.lastReply.get(p.getUniqueId()));
        if (target == null || !target.isOnline()) {
            MEnum.NO_CONNECTED.send(up, new Object[0]);
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < args.length(); ++i) {
            sb.append(args.getArgs(i));
            sb.append(" ");
        }
        String privateMessage = sb.toString();
        this.lastReply.put(target.getUniqueId(), p.getUniqueId());
        MEnum.MSG_SEND.sendTo(p, UHCPlayerManager.getPlayer(target).getName(), privateMessage);
        MEnum.MSG_RECEIVE.sendTo(target, up.getName(), privateMessage);
    }
}

