/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.commands.player.msg;

import eu.scorpionltd.annotations.commands.Command;
import eu.scorpionltd.annotations.commands.CommandArgs;
import eu.scorpionltd.uhc.manager.langues.msg.MEnum;
import eu.scorpionltd.uhc.manager.players.UHCPlayer;
import eu.scorpionltd.uhc.manager.players.UHCPlayerManager;
import eu.scorpionltd.uhc.manager.players.permissions.Permissions;
import eu.scorpionltd.uhc.manager.settings.values.Values;
import eu.scorpionltd.uhc.util.chat.ChatUtil;
import eu.scorpionltd.utils.task.Cooldown;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.entity.Player;

public class HelpOpCommand {
    private List<UUID> cooldown = new ArrayList<UUID>();

    private void sendHelpop(final UHCPlayer p, String question) {
        UHCPlayerManager.getStaffwith(Permissions.HELPOP).forEach(up -> {
            TextComponent component = ChatUtil.getHelpop(p.getName(), question, p.getPlayer().getLocation());
            up.getPlayer().spigot().sendMessage((BaseComponent)component);
        });
        MEnum.HELPOP_SEND.send(p, new Object[0]);
        this.cooldown.add(p.getUUID());
        new Cooldown(30){

            public void onFinish() {
                HelpOpCommand.this.cooldown.remove(p.getUUID());
            }
        };
    }

    @Command(name="helpop", description="Ask help to host", usage="Usage: /helpop <Question>")
    public void onCommand(CommandArgs args) {
        if (!(args.getSender() instanceof Player)) {
            return;
        }
        Player p = args.getPlayer();
        if (args.length() == 0) {
            MEnum.HELPOP_USE.sendTo(p, new Object[0]);
            return;
        }
        if (Values.CHAT_HELPOP_COOLDOWN.getBoolean() && this.cooldown.contains(p.getUniqueId())) {
            MEnum.HELPOP_COOLDOWN.sendTo(p, new Object[0]);
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < args.length(); ++i) {
            sb.append(args.getArgs(i));
            sb.append(" ");
        }
        String question = sb.toString();
        this.sendHelpop(UHCPlayerManager.getPlayer(p), question);
    }
}

