/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.commands.player;

import eu.scorpionltd.annotations.commands.Command;
import eu.scorpionltd.annotations.commands.CommandArgs;
import eu.scorpionltd.uhc.manager.langues.msg.MEnum;
import eu.scorpionltd.uhc.manager.players.UHCPlayer;
import eu.scorpionltd.uhc.manager.players.UHCPlayerManager;
import eu.scorpionltd.uhc.manager.settings.config.ConfigFile;
import eu.scorpionltd.uhc.tasks.TimerManager;
import eu.scorpionltd.uhc.ui.player.infos.MenuGameInventory;
import eu.scorpionltd.uhc.ui.player.infos.MenuGameRules;
import eu.scorpionltd.uhc.ui.player.infos.MenuGameScenarios;
import eu.scorpionltd.uhc.ui.player.profile.MenuStats;
import eu.scorpionltd.uhc.util.player.PlayerUtil;
import eu.scorpionltd.uhc.util.server.ServerUtil;
import eu.scorpionltd.uhc.util.server.enums.Status;
import eu.scorpionltd.utils.player.ScorpionPlayer;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

public class InfosCommand {
    @Command(name="rules", description="Show rules", usage="Usage: /rules", aliases={"rule", "regle", "regles"})
    public void onRulesCommand(CommandArgs args) {
        if (!(args.getSender() instanceof Player)) {
            return;
        }
        new MenuGameRules(ScorpionPlayer.getScorpionPlayer((Player)args.getPlayer())).openMenu();
    }

    @Command(name="scenarios", description="Show scenarios", usage="Usage: /scenarios", aliases={"scenario", "sc", "scs"})
    public void onScenariosCommand(CommandArgs args) {
        if (!(args.getSender() instanceof Player)) {
            return;
        }
        new MenuGameScenarios(ScorpionPlayer.getScorpionPlayer((Player)args.getPlayer())).openMenu();
    }

    @Command(name="inv", description="Show start inventory", usage="Usage: /inv", aliases={"inventory"})
    public void onInventoryCommand(CommandArgs args) {
        if (!(args.getSender() instanceof Player)) {
            return;
        }
        new MenuGameInventory(ScorpionPlayer.getScorpionPlayer((Player)args.getPlayer())).openMenu();
    }

    @Command(name="ping", description="See your connection", usage="Usage: /ping", aliases={"ms", "lag"})
    public void onPingCommand(CommandArgs args) {
        if (!(args.getSender() instanceof Player)) {
            return;
        }
        MEnum.PING_SHOW.sendTo(args.getPlayer(), PlayerUtil.getPing(args.getPlayer()), ServerUtil.getFormattedTPS());
    }

    @Command(name="link", description="Send links of server", usage="Usage: /link", aliases={"links", "lien", "liens"})
    public void onLinkCommand(CommandArgs args) {
        if (!(args.getSender() instanceof Player)) {
            return;
        }
        MEnum.LINK_SHOW.sendTo(args.getPlayer(), new Object[0]);
    }

    @Command(name="timeleft", description="Show timers information", usage="Usage: /timeleft")
    public void onCommand(CommandArgs args) {
        if (!Status.getCurrentStatus().isStart()) {
            return;
        }
        if (!(args.getSender() instanceof Player)) {
            return;
        }
        ScorpionPlayer sp = ScorpionPlayer.getScorpionPlayer((Player)args.getPlayer());
        StringBuilder sb = new StringBuilder();
        TimerManager.getTimersActive().forEach(timer -> sb.append(ChatColor.DARK_GRAY + " - " + ConfigFile.TEXT_COLOR_TEXT.getString() + timer.getPrefix(sp) + ": " + timer.getDisplayTime()).append("\n"));
        MEnum.TIME_SHOW.sendTo(args.getPlayer(), sb.toString());
    }

    @Command(name="stats", description="See player's statistics", usage="Usage: /stats (Player)", aliases={"stat"})
    public void onStatsCommand(CommandArgs args) {
        if (!(args.getSender() instanceof Player)) {
            return;
        }
        Player p = args.getPlayer();
        UHCPlayer up = UHCPlayerManager.getPlayer(p);
        if (args.getArgs().length == 0) {
            new MenuStats(up.getScorpionPlayer(), up, false).openMenu();
            return;
        }
        UHCPlayer target = UHCPlayerManager.getPlayer(args.getArgs(0));
        if (target == null) {
            MEnum.NO_EXISTED.sendTo(p, new Object[0]);
            return;
        }
        new MenuStats(up.getScorpionPlayer(), target, false).openMenu();
    }
}

