/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.commands.host.world.teleport;

import eu.scorpionltd.annotations.commands.Command;
import eu.scorpionltd.annotations.commands.CommandArgs;
import eu.scorpionltd.uhc.manager.langues.msg.MEnum;
import eu.scorpionltd.uhc.manager.players.UHCPlayerManager;
import eu.scorpionltd.uhc.manager.players.permissions.Permissions;
import eu.scorpionltd.uhc.util.world.MathUtil;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class TpCommand {
    @Command(name="tploc", description="Teleport to a location", usage="Usage: /tploc <x> <y> <z> (World Name)")
    public void onTpLocCommand(CommandArgs args) {
        if (!(args.getSender() instanceof Player)) {
            return;
        }
        Player p = args.getPlayer();
        if (!Permissions.TPLOC_CMD.hasPerm(p)) {
            MEnum.NO_PERMISSION.sendTo(p, new Object[0]);
            return;
        }
        if (args.getArgs().length != 3 && args.getArgs().length != 4) {
            MEnum.TPLOC_USE.sendTo(p, new Object[0]);
            return;
        }
        if (!MathUtil.isInt(args.getArgs(0))) {
            MEnum.NOT_NUMBER.sendTo(p, new Object[0]);
            return;
        }
        int x = Integer.parseInt(args.getArgs(0));
        if (!MathUtil.isInt(args.getArgs(1))) {
            MEnum.NOT_NUMBER.sendTo(p, new Object[0]);
            return;
        }
        int y = Integer.parseInt(args.getArgs(1));
        if (!MathUtil.isInt(args.getArgs(2))) {
            MEnum.NOT_NUMBER.sendTo(p, new Object[0]);
            return;
        }
        int z = Integer.parseInt(args.getArgs(2));
        World world = p.getWorld();
        if (args.getArgs().length == 4 && Bukkit.getWorld((String)args.getArgs(3)) != null) {
            world = Bukkit.getWorld((String)args.getArgs(3));
        }
        MEnum.TPLOC_POSITION.sendTo(p, x, y, z, world.getName());
        p.teleport(new Location(world, (double)x, (double)y, (double)z));
    }

    @Command(name="tphere", description="Tp player to you", usage="Usage: /tphere <Player>")
    public void onTpHereCommand(CommandArgs args) {
        if (!(args.getSender() instanceof Player)) {
            return;
        }
        Player p = args.getPlayer();
        if (!Permissions.TPHERE_CMD.hasPerm(p)) {
            MEnum.NO_PERMISSION.sendTo(p, new Object[0]);
            return;
        }
        if (args.getArgs().length != 1) {
            MEnum.TPHERE_USE.sendTo(p, new Object[0]);
            return;
        }
        Player target = Bukkit.getPlayer((String)args.getArgs(0));
        if (target == null || !target.isOnline()) {
            MEnum.NO_CONNECTED.sendTo(p, new Object[0]);
            return;
        }
        MEnum.TPHERE_PLAYER.sendTo(p, UHCPlayerManager.getPlayer(target).getName());
        MEnum.TPHERE_TARGET.sendTo(target, UHCPlayerManager.getPlayer(p).getName());
        target.teleport(p.getLocation());
    }

    @Command(name="tpto", description="Teleport to a player", usage="Usage: /tpto <Player>")
    public void onTpToCommand(CommandArgs args) {
        if (!(args.getSender() instanceof Player)) {
            return;
        }
        Player p = args.getPlayer();
        if (!Permissions.TPLOC_CMD.hasPerm(p)) {
            MEnum.NO_PERMISSION.sendTo(p, new Object[0]);
            return;
        }
        if (args.getArgs().length != 1) {
            MEnum.TPTO_USE.sendTo(p, new Object[0]);
            return;
        }
        Player target = Bukkit.getPlayer((String)args.getArgs(0));
        if (target == null || !target.isOnline()) {
            MEnum.NO_CONNECTED.sendTo(p, new Object[0]);
            return;
        }
        MEnum.TPTO_PLAYER.sendTo(p, UHCPlayerManager.getPlayer(target).getName());
        p.teleport(target.getLocation());
    }
}

