/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.commands.host.world.block;

import eu.scorpionltd.annotations.commands.Command;
import eu.scorpionltd.annotations.commands.CommandArgs;
import eu.scorpionltd.uhc.manager.langues.msg.MEnum;
import eu.scorpionltd.uhc.manager.players.permissions.Permissions;
import eu.scorpionltd.uhc.util.world.MathUtil;
import java.util.Random;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.TreeType;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;

public class TreeCommand {
    @Command(name="tree", description="Spawn trees", usage="Usage: /tree [number of trees] [distance between each tree]")
    public void onCommand(CommandArgs args) {
        String arg2;
        if (!(args.getSender() instanceof Player)) {
            return;
        }
        Player player = args.getPlayer();
        if (!Permissions.TREE_CMD.hasPerm(player)) {
            MEnum.NO_PERMISSION.sendTo(player, new Object[0]);
            return;
        }
        World world = player.getWorld();
        Location betterLocation = this.getFindBetterLocation(player.getLocation());
        TreeType treeType = this.getGoodTreeType(player.getLocation().getBlock().getBiome());
        if (args.length() == 0) {
            world.generateTree(betterLocation, treeType);
            MEnum.TREE_EXECUTE.sendTo(player, new Object[0]);
            return;
        }
        String arg1 = args.getArgs(0);
        if (!MathUtil.isInt(arg1)) {
            MEnum.NOT_NUMBER.sendTo(player, new Object[0]);
            return;
        }
        int trees = Integer.parseInt(arg1);
        int radius = 4;
        if (arg1.length() >= 2 && MathUtil.isInt(arg2 = args.getArgs(1))) {
            radius = Integer.parseInt(arg2);
        }
    }

    private TreeType getGoodTreeType(Biome biome) {
        int rdm = new Random().nextInt(10);
        if (biome == Biome.JUNGLE || biome == Biome.JUNGLE_EDGE || biome == Biome.JUNGLE_EDGE_MOUNTAINS || biome == Biome.JUNGLE_HILLS || biome == Biome.JUNGLE_MOUNTAINS) {
            return TreeType.SMALL_JUNGLE;
        }
        if (biome == Biome.BIRCH_FOREST || biome == Biome.BIRCH_FOREST_HILLS || biome == Biome.BIRCH_FOREST_HILLS_MOUNTAINS || biome == Biome.BIRCH_FOREST_MOUNTAINS) {
            return TreeType.BIRCH;
        }
        if (biome == Biome.TAIGA || biome == Biome.TAIGA_HILLS || biome == Biome.TAIGA_MOUNTAINS || biome == Biome.COLD_TAIGA || biome == Biome.COLD_TAIGA_HILLS || biome == Biome.COLD_TAIGA_MOUNTAINS) {
            return rdm <= 1 ? TreeType.TALL_REDWOOD : TreeType.REDWOOD;
        }
        if (biome == Biome.MEGA_SPRUCE_TAIGA || biome == Biome.MEGA_SPRUCE_TAIGA_HILLS || biome == Biome.MEGA_TAIGA || biome == Biome.MEGA_TAIGA_HILLS) {
            return TreeType.MEGA_REDWOOD;
        }
        return TreeType.TREE;
    }

    private Location getFindBetterLocation(Location location) {
        Location betterLocation = location.clone();
        for (int y = 0; y < 20; ++y) {
            betterLocation.add(0.0, -1.0, 0.0);
            Block block = betterLocation.getBlock();
            if (block.getType() != null && (block.getType() == Material.GRASS || block.getType() == Material.DIRT)) break;
        }
        return betterLocation;
    }
}

