/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.commands.host.player.wl;

import eu.scorpionltd.annotations.commands.Command;
import eu.scorpionltd.annotations.commands.CommandArgs;
import eu.scorpionltd.uhc.events.custom.whitelist.WhitelistAllEvent;
import eu.scorpionltd.uhc.events.custom.whitelist.WhitelistClearEvent;
import eu.scorpionltd.uhc.manager.langues.msg.MEnum;
import eu.scorpionltd.uhc.manager.players.permissions.Permissions;
import eu.scorpionltd.uhc.util.chat.ChatUtil;
import eu.scorpionltd.uhc.util.player.PlayerUtil;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class WhitelistCommand {
    @Command(name="whitelist", description="Modify whitelist", usage="Usage: /whitelist all|clear|list|<add|remove> <Player>", aliases={"wl"})
    public void onWhitelistCommand(CommandArgs args) {
        CommandSender sender = args.getSender();
        if (sender instanceof Player && !Permissions.WHITELIST_CMD.hasPerm((Player)sender)) {
            MEnum.NO_PERMISSION.sendTo((Player)sender, new Object[0]);
            return;
        }
        if (args.getArgs().length == 0 || args.getArgs().length > 2) {
            if (sender instanceof Player) {
                MEnum.WHITELIST_USE.sendTo((Player)sender, new Object[0]);
            } else {
                sender.sendMessage("Use /whitelist all|clear|list|<add|remove> <Player>");
            }
            return;
        }
        String arg1 = args.getArgs(0);
        if (arg1.equalsIgnoreCase("all")) {
            Bukkit.getOnlinePlayers().forEach(player -> player.setWhitelisted(true));
            Bukkit.getPluginManager().callEvent((Event)new WhitelistAllEvent(Bukkit.getWhitelistedPlayers()));
            if (sender instanceof Player) {
                MEnum.WHITELIST_ALL.sendTo((Player)sender, new Object[0]);
            }
            System.out.println("WHITELIST: + ALL PLAYERS");
            return;
        }
        if (arg1.equalsIgnoreCase("clear")) {
            Bukkit.getPluginManager().callEvent((Event)new WhitelistClearEvent(Bukkit.getWhitelistedPlayers()));
            Bukkit.getWhitelistedPlayers().forEach(player -> player.setWhitelisted(false));
            if (sender instanceof Player) {
                MEnum.WHITELIST_CLEAR.sendTo((Player)sender, new Object[0]);
            }
            System.out.println("WHITELIST: - CLEAR PLAYERS");
            return;
        }
        if (arg1.equalsIgnoreCase("list")) {
            Set whitelisted = Bukkit.getWhitelistedPlayers();
            if (whitelisted.isEmpty()) {
                if (sender instanceof Player) {
                    MEnum.WHITELIST_EMPTY.sendTo((Player)sender, new Object[0]);
                } else {
                    System.out.println("The whitelist is empty..");
                }
                return;
            }
            if (sender instanceof Player) {
                MEnum.WHITELIST_LIST.sendTo((Player)sender, whitelisted.size(), ChatUtil.getOfflinePlayerList(whitelisted));
            } else {
                System.out.println("WHITELIST (" + whitelisted.size() + "): " + ChatUtil.getOfflinePlayerList(whitelisted));
            }
            return;
        }
        if (!arg1.equalsIgnoreCase("add") && !arg1.equalsIgnoreCase("remove") || args.getArgs().length != 2) {
            if (sender instanceof Player) {
                MEnum.WHITELIST_USE.sendTo((Player)sender, new Object[0]);
            } else {
                sender.sendMessage("Use /whitelist all|clear|list|<add|remove> <Player>");
            }
            return;
        }
        OfflinePlayer offline = Bukkit.getOfflinePlayer((String)args.getArgs(1));
        if (arg1.equalsIgnoreCase("add")) {
            PlayerUtil.addWhitelist(sender, offline);
            return;
        }
        if (arg1.equalsIgnoreCase("remove")) {
            PlayerUtil.removeWhitelist(sender, offline);
            return;
        }
    }
}

