/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.commands.host.player.wl;

import eu.scorpionltd.annotations.commands.Command;
import eu.scorpionltd.annotations.commands.CommandArgs;
import eu.scorpionltd.uhc.manager.game.whitelist.WhitelistManager;
import eu.scorpionltd.uhc.manager.game.whitelist.WhitelistType;
import eu.scorpionltd.uhc.manager.langues.msg.MEnum;
import eu.scorpionltd.uhc.manager.players.permissions.Permissions;
import eu.scorpionltd.uhc.manager.settings.config.ConfigFile;
import eu.scorpionltd.uhc.util.chat.ChatUtil;
import eu.scorpionltd.uhc.util.server.PacketUtil;
import eu.scorpionltd.uhc.util.server.whitelist.WhitelistMode;
import eu.scorpionltd.uhc.util.server.whitelist.WhitelistStatus;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ForceWhitelistCommand {
    private boolean isForceOpenWhitelist = false;

    @Command(name="forcewl", description="Force whitelist", usage="Usage: /forcewl")
    public void onForceCommand(CommandArgs args) {
        CommandSender sender = args.getSender();
        if (sender instanceof Player && !Permissions.FORCE_WHITELIST_CMD.hasPerm((Player)sender)) {
            MEnum.NO_PERMISSION.sendTo((Player)sender, new Object[0]);
            return;
        }
        this.isForceOpenWhitelist = !this.isForceOpenWhitelist;
        boolean bl = this.isForceOpenWhitelist;
        if (this.isForceOpenWhitelist) {
            WhitelistStatus.setCurrentStatus(WhitelistStatus.OPEN);
            WhitelistType whitelistType = WhitelistManager.getWhitelist(WhitelistMode.PUBLIC);
            if (whitelistType != null) {
                WhitelistManager.setCurrentType(whitelistType);
            }
            if (sender instanceof Player) {
                MEnum.FORCE_OPEN_WHITELIST.sendTo((Player)sender, new Object[0]);
            }
            System.out.println("WHITELIST: FORCE OPEN & PUBLIC by " + sender.getName());
        } else {
            WhitelistStatus.setCurrentStatus(WhitelistStatus.CLOSE);
            WhitelistType whitelistType = WhitelistManager.getWhitelist(WhitelistMode.PRIVATE);
            if (whitelistType != null) {
                WhitelistManager.setCurrentType(whitelistType);
            }
            if (sender instanceof Player) {
                MEnum.FORCE_CLOSE_WHITELIST.sendTo((Player)sender, new Object[0]);
            }
            System.out.println("WHITELIST: FORCE CLOSE & STAFF by " + sender.getName());
        }
    }

    @Command(name="openwl", description="Open whitelist", usage="Usage: /openwl")
    public void onOpenCommand(CommandArgs args) {
        CommandSender sender = args.getSender();
        if (sender instanceof Player && !Permissions.CHANGE_WHITELIST_CMD.hasPerm((Player)sender)) {
            MEnum.NO_PERMISSION.sendTo((Player)sender, new Object[0]);
            return;
        }
        WhitelistStatus.setCurrentStatus(WhitelistStatus.OPEN);
        String annonce = ChatUtil.convertText(ConfigFile.BUNGEE_ANNONCE_OPEN.getString());
        if (ConfigFile.BUNGEE_ENABLE.getBoolean() && annonce != "") {
            PacketUtil.broadcastMessage(sender instanceof Player ? (Player)sender : null, annonce);
        }
        if (sender instanceof Player) {
            MEnum.OPEN_WHITELIST.sendTo((Player)sender, new Object[0]);
        }
        System.out.println("WHITELIST: OPEN by " + sender.getName());
    }

    @Command(name="closewl", description="Close whitelist", usage="Usage: /closewl")
    public void onCloseCommand(CommandArgs args) {
        CommandSender sender = args.getSender();
        if (sender instanceof Player && !Permissions.CHANGE_WHITELIST_CMD.hasPerm((Player)sender)) {
            MEnum.NO_PERMISSION.sendTo((Player)sender, new Object[0]);
            return;
        }
        WhitelistStatus.setCurrentStatus(WhitelistStatus.CLOSE);
        if (sender instanceof Player) {
            MEnum.CLOSE_WHITELIST.sendTo((Player)sender, new Object[0]);
        }
        System.out.println("WHITELIST: CLOSE by " + sender.getName());
    }
}

