/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.commands.host.player.team;

import eu.scorpionltd.annotations.commands.Command;
import eu.scorpionltd.annotations.commands.CommandArgs;
import eu.scorpionltd.uhc.UHC;
import eu.scorpionltd.uhc.manager.langues.msg.MEnum;
import eu.scorpionltd.uhc.manager.players.UHCPlayer;
import eu.scorpionltd.uhc.manager.players.UHCPlayerManager;
import eu.scorpionltd.uhc.manager.players.permissions.Permissions;
import eu.scorpionltd.uhc.manager.settings.values.Values;
import eu.scorpionltd.uhc.manager.teams.UHCTeam;
import eu.scorpionltd.uhc.util.server.enums.Status;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class MooveTeamCommand {
    @Command(name="mooveteam", description="Moove player in a team", usage="Usage: /mooveteam <Player> <Player in a team>")
    public void onCommand(CommandArgs args) {
        if (!args.isPlayer() || Values.TEAM_FFA.getBoolean()) {
            return;
        }
        Player p = args.getPlayer();
        if (!Permissions.MOOVE_TEAM_CMD.hasPerm(p) || Status.getCurrentStatus().isStart() && UHCPlayerManager.getPlayer(p).isPlaying() || !UHCPlayerManager.getPlayer(p).isHost()) {
            MEnum.NO_PERMISSION.sendTo(p, new Object[0]);
            return;
        }
        if (args.getArgs().length != 2) {
            MEnum.MOOVE_TEAM_USE.sendTo(p, new Object[0]);
            return;
        }
        Player target = Bukkit.getPlayer((String)args.getArgs(0));
        Player playerTeam = Bukkit.getPlayer((String)args.getArgs(1));
        if (target == null || playerTeam == null) {
            MEnum.NO_CONNECTED.sendTo(p, new Object[0]);
            return;
        }
        UHCTeam lastTeam = UHC.getTeam(target);
        UHCTeam newTeam = UHC.getTeam(playerTeam);
        if (newTeam == null) {
            MEnum.NO_TEAM.sendTo(p, new Object[0]);
            return;
        }
        UHCPlayer ut = UHCPlayerManager.getPlayer(target);
        UHCPlayer up = UHCPlayerManager.getPlayer(playerTeam);
        if (lastTeam != null) {
            lastTeam.leave(ut);
        }
        newTeam.add(ut);
        MEnum.MOOVE_TEAM_CHANGE.sendTo(p, ut.getName(), up.getName());
    }
}

