/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.commands.host.player.effect;

import eu.scorpionltd.annotations.commands.Command;
import eu.scorpionltd.annotations.commands.CommandArgs;
import eu.scorpionltd.uhc.manager.langues.msg.MEnum;
import eu.scorpionltd.uhc.manager.players.permissions.Permissions;
import eu.scorpionltd.uhc.util.server.enums.Metadata;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class ProtectCommand {
    @Command(name="protect", description="Protect a player", usage="Usage: /protect <Player>")
    public void onCommand(CommandArgs args) {
        if (!(args.getSender() instanceof Player)) {
            return;
        }
        Player p = args.getPlayer();
        if (!Permissions.PROTECT_CMD.hasPerm(p)) {
            MEnum.NO_PERMISSION.sendTo(p, new Object[0]);
            return;
        }
        if (args.getArgs().length != 1) {
            MEnum.PROTECT_USE.sendTo(p, new Object[0]);
            return;
        }
        Player target = Bukkit.getPlayer((String)args.getArgs(0));
        if (target == null || !target.isOnline()) {
            MEnum.NO_CONNECTED.sendTo(p, new Object[0]);
            return;
        }
        if (Metadata.NO_DAMAGE.has(target)) {
            Metadata.NO_DAMAGE.remove(target);
            MEnum.PROTECT_REMOVE_PLAYER.sendTo(p, target.getName());
        } else {
            Metadata.NO_DAMAGE.add(target);
            MEnum.PROTECT_ADD_PLAYER.sendTo(p, target.getName());
        }
    }
}

